/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.tdmsp.ca.root;

import cn.tdchain.tdmsp.ca.config.SystemConfig;
import cn.tdchain.tdmsp.util.PkiUtil;
import java.io.ByteArrayInputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class RsaCertificate {
    public void creatRootCA(String ksPath, String passwd) {
        this.createRoot(ksPath, passwd);
    }

    public void creatOuCert(SystemConfig keyStoreParam) {
        this.creatOrganizationCert(keyStoreParam);
    }

    public void creatOuCert(SystemConfig keyStoreParam, KeyStore rootkeyStore) {
        this.creatOrganizationCert(keyStoreParam, rootkeyStore);
    }

    protected void createRoot(String ksPath, String passwd) {
        SystemConfig systemConfig = new SystemConfig(ksPath, passwd);
        String[] issuer = systemConfig.getIssuerdn().split("@");
        X500Name x500Name = PkiUtil.getNameBuilder(issuer[0], issuer[1], issuer[2]);
        try {
            KeyPair keyPair = this.generateKeyPair();
            PublicKey pulickey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)pulickey.getEncoded());
            byte[] certBuf = PkiUtil.getRootEncodedHolder(subPubKeyInfo, x500Name, systemConfig.getValidTime(), x500Name, privateKey, this.getAlgorithm());
            ByteArrayInputStream inStream = new ByteArrayInputStream(certBuf);
            X509Certificate rootCA = (X509Certificate)CertificateFactory.getInstance("X509", "BC").generateCertificate(inStream);
            systemConfig.setChain(new X509Certificate[]{rootCA});
            PkiUtil.saveRootToKeystore(systemConfig, privateKey, "PKCS12");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void creatOrganizationCert(SystemConfig systemConfig) {
        try {
            KeyPair keyPair = this.generateKeyPair();
            KeyStore rootCaStore = this.getRootCaStore(systemConfig);
            X509Certificate rootCert = (X509Certificate)rootCaStore.getCertificate(systemConfig.getRootAlias());
            X500Principal x500Principal = rootCert.getIssuerX500Principal();
            X500Name issuerDn = new X500Name(x500Principal.getName());
            PrivateKey rootPrivateKey = (PrivateKey)rootCaStore.getKey(systemConfig.getRootAlias(), systemConfig.getRootPassword().toCharArray());
            SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
            X500Name x500Name = PkiUtil.getOuNameBuilder(systemConfig.getCommonName(), systemConfig.getOrganizationUnit(), systemConfig.getCountry());
            byte[] certBuf = PkiUtil.getEncodedHolder(subPubKeyInfo, issuerDn, systemConfig.getValidTime(), x500Name, rootPrivateKey, this.getAlgorithm(), rootCert.getPublicKey());
            ByteArrayInputStream inStream = new ByteArrayInputStream(certBuf);
            X509Certificate organizationCert = (X509Certificate)CertificateFactory.getInstance("X509", "BC").generateCertificate(inStream);
            X509Certificate[] chain = new X509Certificate[]{organizationCert, rootCert};
            systemConfig.setChain(chain);
            PkiUtil.saveCertToKeystore(systemConfig, keyPair.getPrivate(), "PKCS12");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void creatOrganizationCert(SystemConfig keyStoreParam, KeyStore rootkeyStore) {
        try {
            KeyPair keyPair = this.generateKeyPair();
            X509Certificate rootCert = (X509Certificate)rootkeyStore.getCertificate(keyStoreParam.getRootAlias());
            X500Principal x500Principal = rootCert.getIssuerX500Principal();
            X500Name issuerDn = new X500Name(x500Principal.getName());
            PrivateKey rootPrivateKey = (PrivateKey)rootkeyStore.getKey(keyStoreParam.getRootAlias(), keyStoreParam.getRootPassword().toCharArray());
            SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
            X500Name x500Name = PkiUtil.getOuNameBuilder(keyStoreParam.getCommonName(), keyStoreParam.getOrganizationUnit(), keyStoreParam.getCountry());
            byte[] certBuf = PkiUtil.getEncodedHolder(subPubKeyInfo, issuerDn, keyStoreParam.getValidTime(), x500Name, rootPrivateKey, this.getAlgorithm(), rootCert.getPublicKey());
            ByteArrayInputStream inStream = new ByteArrayInputStream(certBuf);
            X509Certificate organizationCert = (X509Certificate)CertificateFactory.getInstance("X509", "BC").generateCertificate(inStream);
            X509Certificate[] chain = new X509Certificate[]{organizationCert, rootCert};
            keyStoreParam.setChain(chain);
            PkiUtil.saveCertToKeystore(keyStoreParam, keyPair.getPrivate(), "PKCS12");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getAlgorithm() {
        return "SHA256withRSA";
    }

    protected KeyPair generateKeyPair() throws Exception {
        return PkiUtil.generateRsaKeyPair();
    }

    private KeyStore getRootCaStore(SystemConfig systemConfig) {
        try {
            return PkiUtil.getKeyStore(systemConfig.getRootKsPath() + systemConfig.getRootKsFileName(), systemConfig.getRootPassword(), "PKCS12");
        }
        catch (Exception e) {
            return null;
        }
    }
}

