package cn.tdchain.api.service.impl;

import java.io.IOException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.alibaba.fastjson.JSONObject;

import cn.tdchain.Trans;
import cn.tdchain.api.rpc.CeConnection;
import cn.tdchain.api.rpc.CeConnectionUtils;
import cn.tdchain.api.service.TemplateService;
import cn.tdchain.cb.constant.KeyAndType;
import cn.tdchain.cb.constant.ResultConstants;
import cn.tdchain.cb.domain.Template;
import cn.tdchain.cb.exception.BusinessException;
import cn.tdchain.cb.util.JsonUtils;
import cn.tdchain.cb.util.StringUtils;
import cn.tdchain.cb.util.ZipUtils;
import cn.tdchain.jbcc.Result;

/**
 * Service Implementation for Contract Template.
 * 
 * @version 1.0
 * @author bingoer.H 2018-12-05
 */
public class TemplateServiceImpl implements TemplateService {

    private static final Logger log = LogManager.getLogger("TD_API");
    private CeConnection con = CeConnectionUtils.getConnection();

    @Override
    public Template findByHash(String hash) throws BusinessException {
        if (StringUtils.isBlank(hash)) {
            throw new BusinessException(ResultConstants.PARAM_ILLEGAL);
        }
        Result<Trans> tx = con.getTransByHash(hash);
        if (tx == null) {
            throw new BusinessException(ResultConstants.HASH_NOT_EXISTS);
        }
        if (!tx.isSuccess()) {
            throw new BusinessException(ResultConstants.GETCHAIN_FAILED);
        }
        if (tx.getEntity() == null
                || StringUtils.isBlank(tx.getEntity().getData())) {
            throw new BusinessException(ResultConstants.NOT_TEMPLATE);
        }
        if (!KeyAndType.T.equals(tx.getEntity().getType())) {
            throw new BusinessException(ResultConstants.NOT_TEMPLATE);
        }
        Template template = JsonUtils.fromJson(tx.getEntity().getData(),
                Template.class);
        if (template == null) {
            throw new BusinessException(ResultConstants.TEMPLATE_NOT_EXISTS);
        }
        String zipped = template.getSourceCode();
        try {
            template.setSourceCode(ZipUtils.gUnzip(zipped));
        } catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        return template;
    }

    @Override
    public JSONObject findByName(String templateName) throws BusinessException {
        if (StringUtils.isBlank(templateName)) {
            throw new BusinessException(ResultConstants.PARAM_ILLEGAL);
        }
        if (templateName.contains(" ")) {
            throw new BusinessException(ResultConstants
                    .getFailedMsg(ResultConstants.SPACE_ILLEGAL, templateName));
        }
        Result<Trans> templateTx = con
                .getNewTransByKey(KeyAndType.getTemplateKey(templateName));
        if (templateTx == null) {
            throw new BusinessException(ResultConstants.TEMPLATE_NOT_EXISTS);
        }
        if (!templateTx.isSuccess()) {
            throw new BusinessException(ResultConstants.GETCHAIN_FAILED);
        }
        if (templateTx.getEntity() == null
                || StringUtils.isBlank(templateTx.getEntity().getData())) {
            throw new BusinessException(ResultConstants.TEMPLATE_NOT_EXISTS);
        }

        Template template = JsonUtils.fromJson(templateTx.getEntity().getData(),
                Template.class);
        if (template == null) {
            throw new BusinessException(ResultConstants.TEMPLATE_NOT_EXISTS);
        }
        String zipped = template.getSourceCode();
        try {
            template.setSourceCode(ZipUtils.gUnzip(zipped));
        } catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        JSONObject temp = JSONObject.parseObject(template.toString());
        temp.put("hash", templateTx.getEntity().getHash());
        return temp;
    }

}
