/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.api;

import cn.tdchain.api.rpc.CeConnection;
import cn.tdchain.api.rpc.CeConnectionUtils;
import cn.tdchain.api.service.ContractService;
import cn.tdchain.api.service.impl.ContractServiceImpl;
import cn.tdchain.cb.constant.ResultConstants;
import cn.tdchain.cb.domain.ContractState;
import cn.tdchain.cb.exception.BusinessException;
import cn.tdchain.cb.util.JsonUtils;
import cn.tdchain.cb.util.StringUtils;
import cn.tdchain.jbcc.rpc.RPCMessage;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;

public class ContractApi {
    private static final String CONTRACT_NAME = "contractName";
    private static final String KS_PASSWORD = "ksPassword";
    private static final String ADDRESS = "address";
    private ContractService contractService = new ContractServiceImpl();
    private CeConnection con = CeConnectionUtils.getConnection();

    public Map<String, String> create(String address, String ksPassword, String contractName, String templateName, String[] args) throws BusinessException {
        if (StringUtils.isBlank((String)address) || StringUtils.isBlank((String)ksPassword) || StringUtils.isBlank((String)contractName) || StringUtils.isBlank((String)templateName) || args == null || args.length == 0) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (contractName.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)contractName));
        }
        RPCMessage msg = this.con.getMessage();
        msg.getCommand().put(ADDRESS, address);
        msg.getCommand().put(KS_PASSWORD, ksPassword);
        msg.getCommand().put(CONTRACT_NAME, contractName);
        msg.getCommand().put("templateName", templateName);
        msg.getCommand().put("args", JsonUtils.toJson((Object)args));
        msg.setTargetType(RPCMessage.TargetType.CREATE_CONTRACT);
        return this.con.sendAndReturn(msg, "Failed to create contract.");
    }

    public Map<String, String> run(String address, String ksPassword, String contractName, String methodName, String[] args) throws BusinessException {
        if (StringUtils.isBlank((String)address) || StringUtils.isBlank((String)ksPassword) || StringUtils.isBlank((String)contractName) || StringUtils.isBlank((String)methodName)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (contractName.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)contractName));
        }
        if (methodName.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)methodName));
        }
        RPCMessage msg = this.con.getMessage();
        msg.getCommand().put(ADDRESS, address);
        msg.getCommand().put(KS_PASSWORD, ksPassword);
        msg.getCommand().put(CONTRACT_NAME, contractName);
        msg.getCommand().put("methodName", methodName);
        msg.getCommand().put("args", JsonUtils.toJson((Object)args));
        msg.setTargetType(RPCMessage.TargetType.RUN_CONTRACT);
        return this.con.sendAndReturn(msg, "Failed to run contract.");
    }

    public Map<String, String> freeze(String address, String ksPassword, String contractName) throws BusinessException {
        if (StringUtils.isBlank((String)address) || StringUtils.isBlank((String)ksPassword) || StringUtils.isBlank((String)contractName)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (contractName.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)contractName));
        }
        RPCMessage msg = this.con.getMessage();
        msg.getCommand().put(ADDRESS, address);
        msg.getCommand().put(KS_PASSWORD, ksPassword);
        msg.getCommand().put(CONTRACT_NAME, contractName);
        msg.setTargetType(RPCMessage.TargetType.FREEZE_CONTRACT);
        return this.con.sendAndReturn(msg, "Failed to freeze contract.");
    }

    public Map<String, String> unfreeze(String address, String ksPassword, String contractName) throws BusinessException {
        if (StringUtils.isBlank((String)address) || StringUtils.isBlank((String)ksPassword) || StringUtils.isBlank((String)contractName)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (contractName.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)contractName));
        }
        RPCMessage msg = this.con.getMessage();
        msg.getCommand().put(ADDRESS, address);
        msg.getCommand().put(KS_PASSWORD, ksPassword);
        msg.getCommand().put(CONTRACT_NAME, contractName);
        msg.setTargetType(RPCMessage.TargetType.UNFREEZE_CONTRACT);
        return this.con.sendAndReturn(msg, "Failed to unfreeze contract.");
    }

    public Map<String, String> update(String address, String ksPassword, String contractName, String[] syncAttrs, String[] newArgs) throws BusinessException {
        if (StringUtils.isBlank((String)address) || StringUtils.isBlank((String)ksPassword) || StringUtils.isBlank((String)contractName) || newArgs == null || newArgs.length == 0) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (contractName.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)contractName));
        }
        RPCMessage msg = this.con.getMessage();
        msg.getCommand().put(ADDRESS, address);
        msg.getCommand().put(KS_PASSWORD, ksPassword);
        msg.getCommand().put(CONTRACT_NAME, contractName);
        msg.getCommand().put("syncAttrs", JsonUtils.toJson((Object)syncAttrs));
        msg.getCommand().put("newArgs", JsonUtils.toJson((Object)newArgs));
        msg.setTargetType(RPCMessage.TargetType.UPDATE_CONTRACT);
        return this.con.sendAndReturn(msg, "Failed to update contract.");
    }

    public Map<String, String> migrateToNewTemplate(String address, String ksPassword, String contractName, String newTemplateName) throws BusinessException {
        if (StringUtils.isBlank((String)address) || StringUtils.isBlank((String)ksPassword) || StringUtils.isBlank((String)contractName) || StringUtils.isBlank((String)newTemplateName)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (contractName.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)contractName));
        }
        RPCMessage msg = this.con.getMessage();
        msg.getCommand().put(ADDRESS, address);
        msg.getCommand().put(KS_PASSWORD, ksPassword);
        msg.getCommand().put(CONTRACT_NAME, contractName);
        msg.getCommand().put("newTemplateName", newTemplateName);
        msg.setTargetType(RPCMessage.TargetType.MIGRATE_CONTRACT);
        return this.con.sendAndReturn(msg, "Failed to migration contract");
    }

    public JSONObject findByHash(String hash) throws BusinessException {
        return this.contractService.findByHash(hash);
    }

    public ContractState findStateByHash(String hash) throws BusinessException {
        return this.contractService.findStateByHash(hash);
    }

    public JSONObject findExByHash(String hash) throws BusinessException {
        return this.contractService.findExByHash(hash);
    }

    public JSONObject findByName(String contractName) throws BusinessException {
        return this.contractService.findByName(contractName);
    }

    public List<JSONObject> queryContractHistory(String contractName) throws BusinessException {
        return this.contractService.queryContractHistory(contractName);
    }

    public List<JSONObject> queryContractStateHistory(String contractName) throws BusinessException {
        return this.contractService.queryContractStateHistory(contractName);
    }

    public String queryContractAttr(String csHash, String attributeName) throws BusinessException {
        if (StringUtils.isBlank((String)csHash) || StringUtils.isBlank((String)attributeName)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (attributeName.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)attributeName));
        }
        RPCMessage msg = this.con.getMessage();
        msg.getCommand().put("contractTxHash", csHash);
        msg.getCommand().put("attributeName", attributeName);
        msg.setTargetType(RPCMessage.TargetType.QUERY_ATTR);
        return this.con.queryAndReturn(msg);
    }

    public String queryContractLatestAttr(String contractName, String attributeName) throws BusinessException {
        if (StringUtils.isBlank((String)contractName) || StringUtils.isBlank((String)attributeName)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (contractName.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)contractName));
        }
        if (attributeName.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)attributeName));
        }
        String hash = this.contractService.queryLatestCsHash(contractName);
        if (StringUtils.isBlank((String)hash)) {
            throw new BusinessException("The contract does not exist.");
        }
        RPCMessage msg = this.con.getMessage();
        msg.getCommand().put("contractTxHash", hash);
        msg.getCommand().put("attributeName", attributeName);
        msg.setTargetType(RPCMessage.TargetType.QUERY_ATTR);
        return this.con.queryAndReturn(msg);
    }
}

