/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.api.service.impl;

import cn.tdchain.Trans;
import cn.tdchain.api.config.SystemConfig;
import cn.tdchain.api.rpc.CeConnection;
import cn.tdchain.api.rpc.CeConnectionUtils;
import cn.tdchain.api.service.AccountService;
import cn.tdchain.cb.constant.KeyAndType;
import cn.tdchain.cb.constant.ResultConstants;
import cn.tdchain.cb.domain.Account;
import cn.tdchain.cb.domain.AccountContract;
import cn.tdchain.cb.domain.AccountTemplate;
import cn.tdchain.cb.domain.Auth;
import cn.tdchain.cb.domain.BaseEntity;
import cn.tdchain.cb.domain.ContractState;
import cn.tdchain.cb.exception.BusinessException;
import cn.tdchain.cb.service.impl.CipherServiceImpl;
import cn.tdchain.cb.util.AddressUtils;
import cn.tdchain.cb.util.Base64Util;
import cn.tdchain.cb.util.CollectionUtils;
import cn.tdchain.cb.util.IOUtils;
import cn.tdchain.cb.util.JsonUtils;
import cn.tdchain.cb.util.StringUtils;
import cn.tdchain.cb.util.TdcbConfig;
import cn.tdchain.cb.util.TransUtils;
import cn.tdchain.cipher.Cipher;
import cn.tdchain.jbcc.DateUtils;
import cn.tdchain.jbcc.Result;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class AccountServiceImpl
implements AccountService {
    private CipherServiceImpl cipherService = new CipherServiceImpl();
    private CeConnection con = CeConnectionUtils.getConnection();

    @Override
    public String createSuper() throws BusinessException {
        String superAddress = SystemConfig.getInstance().getSuperAddress();
        if (superAddress.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)superAddress));
        }
        Account superAccount = this.findLatest(superAddress);
        if (superAccount != null) {
            throw new BusinessException("The account already exists.");
        }
        String keyPath = AddressUtils.getKsFilePath((String)superAddress);
        String pubKey = this.cipherService.getPublicKeyStr(Cipher.Type.RSA.name(), keyPath, SystemConfig.getInstance().getSuperPassword());
        if (StringUtils.isBlank((String)pubKey)) {
            throw new BusinessException("Failed to get public key.");
        }
        String keyStoreStr = IOUtils.getBytes((String)keyPath);
        if (StringUtils.isBlank((String)keyStoreStr)) {
            throw new BusinessException("Failed to get keystore.");
        }
        Account newAccount = new Account(superAddress, Cipher.Type.RSA.name(), keyStoreStr, null, DateUtils.getCurrentTime());
        newAccount.setAuth(Auth.SUPER);
        Trans tx = TransUtils.createTrans((BaseEntity)newAccount, (String)this.con.getCon().getAccount(), (Long)newAccount.getTimestamp());
        Result txResult = this.con.getCon().addTrans(tx);
        if (txResult != null && txResult.isSuccess()) {
            return superAddress;
        }
        throw new BusinessException(ResultConstants.getFailedMsg((String)"Failed to create account.", (String)txResult.getMsg()));
    }

    @Override
    public String create(String ksPassword, String crypto, String info) throws BusinessException {
        if (StringUtils.isBlank((String)ksPassword) || StringUtils.isBlank((String)crypto)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        String address = this.cipherService.generateKeyStore(crypto = crypto.toUpperCase(), ksPassword);
        if (StringUtils.isBlank((String)address)) {
            throw new BusinessException("Failed to get keystore.");
        }
        String keyPath = AddressUtils.getKsFilePath((String)address);
        String keyStoreStr = IOUtils.getBytes((String)keyPath);
        if (StringUtils.isBlank((String)keyStoreStr)) {
            throw new BusinessException("Failed to get keystore.");
        }
        String pubKey = this.cipherService.getPublicKeyStr(crypto, keyPath, ksPassword);
        if (StringUtils.isBlank((String)pubKey)) {
            throw new BusinessException("Failed to get public key.");
        }
        String encryptedInfo = null;
        if (!StringUtils.isBlank((String)info) && StringUtils.isBlank((String)(encryptedInfo = this.cipherService.encrypt(crypto, info, pubKey)))) {
            throw new BusinessException("Failed to encrypt user info.");
        }
        Account account = new Account(address, crypto, keyStoreStr, encryptedInfo, DateUtils.getCurrentTime());
        Trans tx = TransUtils.createTrans((BaseEntity)account, (String)this.con.getCon().getAccount(), (Long)account.getTimestamp());
        Result txResult = this.con.getCon().addTrans(tx);
        if (txResult != null && txResult.isSuccess()) {
            return address;
        }
        throw new BusinessException(ResultConstants.getFailedMsg((String)"Failed to create account.", (String)txResult.getMsg()));
    }

    @Override
    public String encryptInfo(String address, String ksPassword, String info) throws BusinessException {
        String publicKey;
        if (StringUtils.isBlank((String)address) || StringUtils.isBlank((String)ksPassword) || StringUtils.isBlank((String)info)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        Result<Trans> latest = this.con.getNewTransByKey(KeyAndType.getAccountKey((String)address));
        if (latest == null) {
            throw new BusinessException("The account does not exist.");
        }
        if (!latest.isSuccess()) {
            throw new BusinessException("Failed to query on chain.");
        }
        if (latest.getEntity() == null || StringUtils.isBlank((String)((Trans)latest.getEntity()).getData())) {
            throw new BusinessException("The account does not exist.");
        }
        Account account = (Account)JsonUtils.fromJson((String)((Trans)latest.getEntity()).getData(), Account.class);
        if (account == null) {
            throw new BusinessException("The account does not exist.");
        }
        if (account.isFrozen()) {
            throw new BusinessException("The account is frozen.");
        }
        if (StringUtils.isBlank((String)account.getKeyStore())) {
            throw new BusinessException("Failed to get keystore.");
        }
        String filePath = AddressUtils.getKsFilePath((String)account.getAddress());
        File file = new File(filePath);
        if (!file.exists()) {
            IOUtils.generateFile((String)account.getKeyStore(), (String)TdcbConfig.getInstance().getAccountKsPath(), (String)filePath);
        }
        if (StringUtils.isBlank((String)(publicKey = this.cipherService.getPublicKeyStr(account.getCrypto(), filePath, ksPassword)))) {
            throw new BusinessException("Failed to get public key.");
        }
        String keyStoreAddress = this.cipherService.getAddress(account.getCrypto(), publicKey);
        if (!account.getAddress().equals(keyStoreAddress)) {
            throw new BusinessException("Keystore not match.");
        }
        String encryptedInfo = this.cipherService.encrypt(account.getCrypto(), info, publicKey);
        if (StringUtils.isBlank((String)encryptedInfo)) {
            throw new BusinessException("Failed to encrypt user info.");
        }
        return encryptedInfo;
    }

    @Override
    public JSONObject findLatestWithoutKs(String address) throws BusinessException {
        if (StringUtils.isBlank((String)address)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (address.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)address));
        }
        Result<Trans> tx = this.con.getNewTransByKey(KeyAndType.getAccountKey((String)address));
        if (tx == null) {
            throw new BusinessException("The account does not exist.");
        }
        if (!tx.isSuccess()) {
            throw new BusinessException("Failed to query on chain.");
        }
        if (tx.getEntity() == null || StringUtils.isBlank((String)((Trans)tx.getEntity()).getData())) {
            throw new BusinessException("The account does not exist.");
        }
        JSONObject temp = JSONObject.parseObject((String)((Trans)tx.getEntity()).getData());
        temp.put("hash", (Object)((Trans)tx.getEntity()).getHash());
        temp.remove((Object)"keyStore");
        return temp;
    }

    @Override
    public String findInfo(String address, String ksPassword) throws BusinessException {
        String privateKey;
        if (StringUtils.isBlank((String)address) || StringUtils.isBlank((String)ksPassword)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (address.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)address));
        }
        Account account = this.findLatest(address);
        if (account == null) {
            throw new BusinessException("The account does not exist.");
        }
        if (StringUtils.isBlank((String)account.getInfo())) {
            return null;
        }
        String filePath = AddressUtils.getKsFilePath((String)account.getAddress());
        File file = new File(filePath);
        if (!file.exists()) {
            IOUtils.generateFile((String)account.getKeyStore(), (String)TdcbConfig.getInstance().getAccountKsPath(), (String)filePath);
        }
        if (StringUtils.isBlank((String)(privateKey = this.cipherService.getPrivateKeyStr(account.getCrypto(), filePath, ksPassword)))) {
            return account.getInfo();
        }
        return this.cipherService.decrypt(account.getCrypto(), account.getInfo(), privateKey);
    }

    @Override
    public List<JSONObject> queryHistory(String address) throws BusinessException {
        if (StringUtils.isBlank((String)address)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (address.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)address));
        }
        ArrayList<JSONObject> accounts = new ArrayList<JSONObject>();
        Result<List<Trans>> alTxs = this.con.getTransHistoryByKey(KeyAndType.getAccountKey((String)address));
        if (alTxs == null) {
            return accounts;
        }
        if (!alTxs.isSuccess()) {
            throw new BusinessException("Failed to query on chain.");
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)alTxs.getEntity()))) {
            return accounts;
        }
        ((List)alTxs.getEntity()).forEach(tx -> {
            JSONObject temp = JSONObject.parseObject((String)tx.getData());
            temp.put("hash", (Object)tx.getHash());
            temp.remove((Object)"keyStore");
            accounts.add(temp);
        });
        return accounts;
    }

    @Override
    public List<String> queryContractNames(String address) throws BusinessException {
        if (StringUtils.isBlank((String)address)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (address.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)address));
        }
        ArrayList<String> contracts = new ArrayList<String>();
        Result<List<Trans>> txs = this.con.getTransListByType(KeyAndType.getAccountContractType((String)address));
        if (txs == null) {
            return contracts;
        }
        if (!txs.isSuccess()) {
            throw new BusinessException("Failed to query on chain.");
        }
        if (txs.getEntity() == null || CollectionUtils.isEmpty((Collection)((Collection)txs.getEntity()))) {
            return contracts;
        }
        ((List)txs.getEntity()).forEach(tx -> {
            AccountContract ac;
            if (tx.getData() != null && (ac = (AccountContract)JsonUtils.fromJson((String)tx.getData(), AccountContract.class)) != null) {
                contracts.add(ac.getContractName());
            }
        });
        return contracts;
    }

    private Account findLatest(String address) throws BusinessException {
        if (StringUtils.isBlank((String)address)) {
            return null;
        }
        if (address.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)address));
        }
        try {
            Result<Trans> tx = this.con.getNewTransByKey(KeyAndType.getAccountKey((String)address));
            if (tx == null) {
                return null;
            }
            if (!tx.isSuccess()) {
                throw new BusinessException("Failed to query on chain.");
            }
            if (tx.getEntity() == null || StringUtils.isBlank((String)((Trans)tx.getEntity()).getData())) {
                return null;
            }
            return (Account)JsonUtils.fromJson((String)((Trans)tx.getEntity()).getData(), Account.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<String> queryTemplateNames(String address) throws BusinessException {
        if (StringUtils.isBlank((String)address)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (address.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)address));
        }
        ArrayList<String> templates = new ArrayList<String>();
        Result<List<Trans>> txs = this.con.getTransListByType(KeyAndType.getAccountTemplateType((String)address));
        if (txs == null) {
            return templates;
        }
        if (!txs.isSuccess()) {
            throw new BusinessException("Failed to query on chain.");
        }
        if (txs.getEntity() == null || CollectionUtils.isEmpty((Collection)((Collection)txs.getEntity()))) {
            return templates;
        }
        ((List)txs.getEntity()).forEach(tx -> {
            AccountTemplate at;
            if (tx.getData() != null && (at = (AccountTemplate)JsonUtils.fromJson((String)tx.getData(), AccountTemplate.class)) != null) {
                templates.add(at.getTemplateName());
            }
        });
        return templates;
    }

    @Override
    public List<JSONObject> queryLedger(String address) throws BusinessException {
        if (StringUtils.isBlank((String)address)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (address.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)address));
        }
        Result<List<Trans>> txs = this.con.getTransListByType(KeyAndType.getAccountLedgerType((String)address));
        ArrayList<JSONObject> ledger = new ArrayList<JSONObject>();
        if (txs == null) {
            return ledger;
        }
        if (!txs.isSuccess()) {
            throw new BusinessException("Failed to query on chain.");
        }
        if (txs.getEntity() == null || CollectionUtils.isEmpty((Collection)((Collection)txs.getEntity()))) {
            return ledger;
        }
        ((List)txs.getEntity()).forEach(tx -> {
            if (StringUtils.isNotBlank((String)tx.getData())) {
                JSONObject temp = JSONObject.parseObject((String)tx.getData());
                temp.put("hash", (Object)tx.getHash());
                temp.put("csHash", (Object)(temp.get((Object)"referenceHash") + tx.getHeight().toString()));
                ledger.add(temp);
            }
        });
        return ledger;
    }

    @Override
    public List<JSONObject> queryLedgerHistory(String address, String contractName) throws BusinessException {
        if (StringUtils.isBlank((String)address) || StringUtils.isBlank((String)contractName)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (address.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)address));
        }
        if (contractName.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)contractName));
        }
        ArrayList<JSONObject> history = new ArrayList<JSONObject>();
        Result<List<Trans>> alTxs = this.con.getTransHistoryByKey(KeyAndType.getAccountLedgerKey((String)address, (String)contractName));
        if (alTxs == null) {
            return history;
        }
        if (!alTxs.isSuccess()) {
            throw new BusinessException("Failed to query on chain.");
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)alTxs.getEntity()))) {
            return history;
        }
        ((List)alTxs.getEntity()).forEach(tx -> {
            if (StringUtils.isNotBlank((String)tx.getData())) {
                JSONObject temp = JSONObject.parseObject((String)tx.getData());
                temp.put("hash", (Object)tx.getHash());
                temp.put("csHash", (Object)(temp.get((Object)"referenceHash") + tx.getHeight().toString()));
                history.add(temp);
            }
        });
        return history;
    }

    @Override
    public List<JSONObject> queryLedgerHistoryEx(String address, String contractName) throws BusinessException {
        if (StringUtils.isBlank((String)address) || StringUtils.isBlank((String)contractName)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (address.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)address));
        }
        if (contractName.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)contractName));
        }
        ArrayList<JSONObject> history = new ArrayList<JSONObject>();
        Result<List<Trans>> alTxs = this.con.getTransHistoryByKey(KeyAndType.getAccountLedgerKey((String)address, (String)contractName));
        if (alTxs == null) {
            return history;
        }
        if (!alTxs.isSuccess()) {
            throw new BusinessException("Failed to query on chain.");
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)alTxs.getEntity()))) {
            return history;
        }
        ((List)alTxs.getEntity()).forEach(tx -> history.add(this.construct((Trans)tx)));
        return history;
    }

    private JSONObject construct(Trans latest) {
        JSONObject temp = JSONObject.parseObject((String)latest.getData());
        temp.put("hash", (Object)latest.getHash());
        String csHash = temp.getString("referenceHash") + latest.getHeight().toString();
        temp.put("csHash", (Object)csHash);
        Result<Trans> refCs = this.con.getTransByHash(csHash);
        if (refCs == null || !refCs.isSuccess() || refCs.getEntity() == null || StringUtils.isBlank((String)((Trans)refCs.getEntity()).getData())) {
            return temp;
        }
        ContractState cs = (ContractState)JsonUtils.fromJson((String)((Trans)refCs.getEntity()).getData(), ContractState.class);
        temp.put("operator", (Object)cs.getOperator());
        temp.put("operation", (Object)cs.getOperation());
        this.parseOpr(cs.getOprMap(), "CREATE_ARGS");
        this.parseOpr(cs.getOprMap(), "UPDATE_ARGS");
        this.parseOpr(cs.getOprMap(), "UPDATE_SYNC_ARGS");
        this.parseOpr(cs.getOprMap(), "RUN_ARGS");
        temp.put("oprMap", (Object)cs.getOprMap());
        return temp;
    }

    private void parseOpr(Map<String, Object> oprMap, String key) {
        if (oprMap.containsKey(key)) {
            oprMap.put(key, Base64Util.decoder((String)((String)oprMap.get(key))));
        }
    }

    @Override
    public JSONObject getAccountStatistic(String address) throws BusinessException {
        Result<Integer> acs;
        Result<Integer> ats;
        if (StringUtils.isBlank((String)address)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        address = address.trim();
        JSONObject result = new JSONObject();
        Result<Integer> als = this.con.getTransCountByType(KeyAndType.getAccountLedgerType((String)address));
        if (als.isSuccess()) {
            result.put("asset", als.getEntity());
        }
        if ((ats = this.con.getTransCountByType(KeyAndType.getAccountTemplateType((String)address))).isSuccess()) {
            result.put("template", ats.getEntity());
        }
        if ((acs = this.con.getTransCountByType(KeyAndType.getAccountContractType((String)address))).isSuccess()) {
            result.put("contract", acs.getEntity());
        }
        return result;
    }
}

