/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.api.service.impl;

import cn.tdchain.Trans;
import cn.tdchain.api.rpc.CeConnection;
import cn.tdchain.api.rpc.CeConnectionUtils;
import cn.tdchain.api.service.AccountService;
import cn.tdchain.api.service.ContractService;
import cn.tdchain.api.service.impl.AccountServiceImpl;
import cn.tdchain.cb.constant.KeyAndType;
import cn.tdchain.cb.constant.ResultConstants;
import cn.tdchain.cb.domain.Contract;
import cn.tdchain.cb.domain.ContractState;
import cn.tdchain.cb.exception.BusinessException;
import cn.tdchain.cb.util.Base64Util;
import cn.tdchain.cb.util.CollectionUtils;
import cn.tdchain.cb.util.JsonUtils;
import cn.tdchain.cb.util.StringUtils;
import cn.tdchain.jbcc.Result;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ContractServiceImpl
implements ContractService {
    private AccountService accountService = new AccountServiceImpl();
    private CeConnection con = CeConnectionUtils.getConnection();

    @Override
    public JSONObject findByHash(String hash) throws BusinessException {
        if (StringUtils.isBlank((String)hash)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        Result<Trans> tx = this.con.getTransByHash(hash);
        if (tx == null) {
            throw new BusinessException("The hash not exists on chain.");
        }
        if (!tx.isSuccess()) {
            throw new BusinessException("Failed to query on chain.");
        }
        if (tx.getEntity() == null || StringUtils.isBlank((String)((Trans)tx.getEntity()).getData())) {
            throw new BusinessException("Not a contract record.");
        }
        if (((Trans)tx.getEntity()).getType().equals("C")) {
            Contract contract = this.parseContract((Trans)tx.getEntity());
            if (contract == null) {
                throw new BusinessException("Not a contract record.");
            }
            String csHash = contract.getReferenceHash() + ((Trans)tx.getEntity()).getHeight().toString();
            JSONObject temp = JSONObject.parseObject((String)contract.toString());
            temp.put("csHash", (Object)csHash);
            return temp;
        }
        throw new BusinessException("Not a contract record.");
    }

    @Override
    public ContractState findStateByHash(String hash) throws BusinessException {
        if (StringUtils.isBlank((String)hash)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        Result<Trans> tx = this.con.getTransByHash(hash);
        if (tx == null) {
            throw new BusinessException("The hash not exists on chain.");
        }
        if (!tx.isSuccess()) {
            throw new BusinessException("Failed to query on chain.");
        }
        if (tx.getEntity() == null || StringUtils.isBlank((String)((Trans)tx.getEntity()).getData())) {
            throw new BusinessException("Not a contract state record.");
        }
        if (((Trans)tx.getEntity()).getType().equals("CS")) {
            ContractState cs = this.parseContractState((Trans)tx.getEntity());
            if (cs == null) {
                throw new BusinessException("Not a contract state record.");
            }
            cs.setCompiled(null);
            return cs;
        }
        throw new BusinessException("Not a contract state record.");
    }

    @Override
    public JSONObject findExByHash(String hash) throws BusinessException {
        if (StringUtils.isBlank((String)hash)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        Result<Trans> tx = this.con.getTransByHash(hash);
        if (tx == null) {
            throw new BusinessException("The hash not exists on chain.");
        }
        if (!tx.isSuccess()) {
            throw new BusinessException("Failed to query on chain.");
        }
        if (tx.getEntity() == null || StringUtils.isBlank((String)((Trans)tx.getEntity()).getData())) {
            throw new BusinessException("Not a contract record.");
        }
        if (((Trans)tx.getEntity()).getType().equals("C")) {
            Contract contract = this.parseContract((Trans)tx.getEntity());
            if (contract == null) {
                throw new BusinessException("Not a contract record.");
            }
            String csHash = contract.getReferenceHash() + ((Trans)tx.getEntity()).getHeight().toString();
            ContractState cs = this.findStateByHash(csHash);
            JSONObject temp = JSONObject.parseObject((String)cs.toString());
            temp.put("createTime", (Object)contract.getCreateTime());
            temp.put("description", (Object)contract.getDescription());
            temp.put("timestamp", (Object)contract.getTimestamp());
            temp.put("version", (Object)contract.getVersion());
            temp.put("hash", (Object)((Trans)tx.getEntity()).getHash());
            temp.put("csHash", (Object)csHash);
            return temp;
        }
        throw new BusinessException("Not a contract record.");
    }

    private Contract parseContract(Trans tx) {
        if (tx == null || StringUtils.isBlank((String)tx.getData())) {
            return null;
        }
        Contract contract = (Contract)JsonUtils.fromJson((String)tx.getData(), Contract.class);
        if (contract == null) {
            return null;
        }
        contract.setArgs(Base64Util.decoder((String)contract.getArgs()));
        return contract;
    }

    private ContractState parseContractState(Trans tx) {
        if (tx == null || StringUtils.isBlank((String)tx.getData())) {
            return null;
        }
        ContractState contract = (ContractState)JsonUtils.fromJson((String)tx.getData(), ContractState.class);
        if (contract == null) {
            return null;
        }
        this.parseOpr(contract.getOprMap(), "CREATE_ARGS");
        this.parseOpr(contract.getOprMap(), "UPDATE_ARGS");
        this.parseOpr(contract.getOprMap(), "UPDATE_SYNC_ARGS");
        this.parseOpr(contract.getOprMap(), "RUN_ARGS");
        return contract;
    }

    private void parseOpr(Map<String, Object> oprMap, String key) {
        if (oprMap.containsKey(key)) {
            oprMap.put(key, Base64Util.decoder((String)((String)oprMap.get(key))));
        }
    }

    @Override
    public JSONObject findByName(String contractName) throws BusinessException {
        if (StringUtils.isBlank((String)contractName)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (contractName.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)contractName));
        }
        String contractKey = KeyAndType.getContractKey((String)contractName);
        Result<Trans> tx = this.con.getNewTransByKey(contractKey);
        if (tx == null) {
            throw new BusinessException("The contract does not exist.");
        }
        if (!tx.isSuccess()) {
            throw new BusinessException("Failed to query on chain.");
        }
        if (tx.getEntity() == null || StringUtils.isBlank((String)((Trans)tx.getEntity()).getData())) {
            throw new BusinessException("The contract does not exist.");
        }
        Contract contract = this.parseContract((Trans)tx.getEntity());
        if (contract == null) {
            throw new BusinessException("Not a contract record.");
        }
        JSONObject temp = JSONObject.parseObject((String)contract.toString());
        temp.put("hash", (Object)((Trans)tx.getEntity()).getHash());
        temp.put("csHash", (Object)(temp.get((Object)"referenceHash") + ((Trans)tx.getEntity()).getHeight().toString()));
        return temp;
    }

    @Override
    public List<JSONObject> queryByOwner(String address) throws BusinessException {
        ArrayList<JSONObject> contracts = new ArrayList<JSONObject>();
        if (StringUtils.isBlank((String)address)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        List<String> contractNameList = this.accountService.queryContractNames(address);
        if (CollectionUtils.isEmpty(contractNameList)) {
            return contracts;
        }
        for (String contractName : contractNameList) {
            Contract contract;
            Result<Trans> tx = this.con.getNewTransByKey(KeyAndType.getContractKey((String)contractName));
            if (tx == null || !tx.isSuccess() || tx.getEntity() == null || StringUtils.isBlank((String)((Trans)tx.getEntity()).getData()) || (contract = this.parseContract((Trans)tx.getEntity())) == null) continue;
            JSONObject temp = JSONObject.parseObject((String)contract.toString());
            temp.put("hash", (Object)((Trans)tx.getEntity()).getHash());
            contracts.add(temp);
        }
        return contracts;
    }

    @Override
    public List<JSONObject> queryContractHistory(String contractName) throws BusinessException {
        if (StringUtils.isBlank((String)contractName)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        ArrayList<JSONObject> contracts = new ArrayList<JSONObject>();
        Result<List<Trans>> contractTxs = this.con.getTransHistoryByKey(KeyAndType.getContractKey((String)contractName));
        if (contractTxs == null) {
            throw new BusinessException("The contract does not exist.");
        }
        if (!contractTxs.isSuccess()) {
            throw new BusinessException("Failed to query on chain.");
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)contractTxs.getEntity()))) {
            throw new BusinessException("The contract does not exist.");
        }
        ((List)contractTxs.getEntity()).forEach(tx -> {
            Contract contract = this.parseContract((Trans)tx);
            if (contract != null) {
                JSONObject temp = JSONObject.parseObject((String)contract.toString());
                temp.put("hash", (Object)tx.getHash());
                temp.put("csHash", (Object)(temp.get((Object)"referenceHash") + tx.getHeight().toString()));
                contracts.add(temp);
            }
        });
        return contracts;
    }

    @Override
    public List<JSONObject> queryContractStateHistory(String contractName) throws BusinessException {
        ArrayList<JSONObject> contracts = new ArrayList<JSONObject>();
        if (StringUtils.isBlank((String)contractName)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        Result<List<Trans>> contractTxs = this.con.getTransHistoryByKey(KeyAndType.getContractStateKey((String)contractName));
        if (contractTxs == null) {
            throw new BusinessException("The contract does not exist.");
        }
        if (!contractTxs.isSuccess()) {
            throw new BusinessException("Failed to query on chain.");
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)contractTxs.getEntity()))) {
            throw new BusinessException("The contract does not exist.");
        }
        ((List)contractTxs.getEntity()).forEach(tx -> {
            ContractState cs = this.parseContractState((Trans)tx);
            if (cs != null) {
                JSONObject temp = JSONObject.parseObject((String)cs.toString());
                temp.remove((Object)"compiled");
                temp.put("hash", (Object)tx.getHash());
                contracts.add(temp);
            }
        });
        return contracts;
    }

    @Override
    public String queryLatestCsHash(String contractName) throws BusinessException {
        if (StringUtils.isBlank((String)contractName)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        Result<Trans> latest = this.con.getNewTransByKey(KeyAndType.getContractStateKey((String)contractName));
        if (latest == null || !latest.isSuccess() || latest.getEntity() == null || StringUtils.isBlank((String)((Trans)latest.getEntity()).getData())) {
            return null;
        }
        return ((Trans)latest.getEntity()).getHash();
    }
}

