package cn.tdchain.api.config;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

/**
 * System Configuration Utility.
 *
 * @version 1.0
 * @author Bingoer.H 2018-11-27
 */
public class SystemConfig {

    private static volatile SystemConfig instance;
    private static final String SYSTEM_CONFIG_FILE = "tdcb.properties";

    private String[] ceIpTables;
    private String superPassword;
    private String superAddress;
    private int timeout;

    private void init() {
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(
                    SYSTEM_CONFIG_FILE);

            String ips = config.getString("tdcb.connection.ce.iptables");
            if (ips != null && ips.length() > 0) {
                ceIpTables = ips.split(";");
            }

            timeout = config.getInt("tdcb.connection.timeout");
            superAddress = config.getString("tdcb.contract.super.address");
            superPassword = config.getString("tdcb.contract.super.password");
        } catch (ConfigurationException e) {
            throw new RuntimeException(
                    "Failed to load " + SYSTEM_CONFIG_FILE + ".");

        }

    }

    /**
     * Get instance.
     * 
     * @return instance
     */
    public static synchronized SystemConfig getInstance() {
        if (instance == null) {
            instance = new SystemConfig();
            instance.init();
        }
        return instance;
    }

    /**
     * Override super address and password.
     * 
     * @param superAddress String
     * @param superPassword String
     */
    public void overrideSuper(String superAddress, String superPassword) {
        this.superAddress = superAddress;
        this.superPassword = superPassword;
    }

    public String[] getCeIpTables() {
        return ceIpTables;
    }

    public int getTimeout() {
        return timeout;
    }

    public String getSuperAddress() {
        return superAddress;
    }

    public String getSuperPassword() {
        return superPassword;
    }

}
