package cn.tdchain.api.service;

import java.util.List;

import com.alibaba.fastjson.JSONObject;

import cn.tdchain.cb.domain.ContractState;
import cn.tdchain.cb.exception.BusinessException;

/**
 * Service for Contract.
 *
 * @version 1.0
 * @author Bingoer.H 2018-12-04
 */
public interface ContractService {

    /**
     * Query contract by hash.
     * 
     * @param hash contract hash
     * @return contract data
     * @throws BusinessException business exception
     */
    JSONObject findByHash(String hash) throws BusinessException;

    /**
     * Query contract state by hash.
     * 
     * @param hash contract state hash
     * @return contract state data
     * @throws BusinessException business exception
     */
    ContractState findStateByHash(String hash) throws BusinessException;

    /**
     * Query contract and state by contract hash.
     * 
     * @param hash contract hash
     * @return contract and state data
     * @throws BusinessException business exception
     */
    JSONObject findExByHash(String hash) throws BusinessException;

    /**
     * Query contract by name.
     * 
     * @param contractName contract name
     * @return contract data
     * @throws BusinessException business exception
     */
    JSONObject findByName(String contractName) throws BusinessException;

    /**
     * Query contracts by owner(up to 1000 records).
     * 
     * @param address owner address
     * @return contract data
     * @throws BusinessException business exception
     */
    List<JSONObject> queryByOwner(String address) throws BusinessException;

    /**
     * Query contract history(up to 20 records).
     * 
     * @param contractName contract name
     * @return contract history
     * @throws BusinessException business exception
     */
    List<JSONObject> queryContractHistory(String contractName)
        throws BusinessException;

    /**
     * Query contract state history(up to 20 records).
     * 
     * @param contractName contract name
     * @return contract state history
     * @throws BusinessException business exception
     */
    List<JSONObject> queryContractStateHistory(String contractName)
        throws BusinessException;

    /**
     * Query latest contract state hash.
     * 
     * @param contractName contract name
     * @return latest contract state hash
     * @throws BusinessException business exception
     */
    String queryLatestCsHash(String contractName) throws BusinessException;

}
