package cn.tdchain.api.service;

import com.alibaba.fastjson.JSONObject;

import cn.tdchain.cb.domain.Template;
import cn.tdchain.cb.exception.BusinessException;

/**
 * Service for Contract Template.
 * 
 * @version 1.0
 * @author bingoer.H 2018-12-05
 */
public interface TemplateService {

    /**
     * Query template by hash.
     * 
     * @param hash template hash
     * @return template data
     * @throws BusinessException business exception
     */
    Template findByHash(String hash) throws BusinessException;

    /**
     * Query template by name.
     * 
     * @param templateName template name
     * @return template data
     * @throws BusinessException business exception
     */
    JSONObject findByName(String templateName) throws BusinessException;

}
