/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.api.config;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class SystemConfig {
    private static volatile SystemConfig instance;
    private static final String SYSTEM_CONFIG_FILE = "tdcb.properties";
    private String[] ceIpTables;
    private String superPassword;
    private String superAddress;
    private int timeout;

    private void init() {
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(SYSTEM_CONFIG_FILE);
            String ips = config.getString("tdcb.connection.ce.iptables");
            if (ips != null && ips.length() > 0) {
                this.ceIpTables = ips.split(";");
            }
            this.timeout = config.getInt("tdcb.connection.timeout");
            this.superAddress = config.getString("tdcb.contract.super.address");
            this.superPassword = config.getString("tdcb.contract.super.password");
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Failed to load tdcb.properties.");
        }
    }

    public static synchronized SystemConfig getInstance() {
        if (instance == null) {
            instance = new SystemConfig();
            instance.init();
        }
        return instance;
    }

    public void overrideSuper(String superAddress, String superPassword) {
        this.superAddress = superAddress;
        this.superPassword = superPassword;
    }

    public String[] getCeIpTables() {
        return this.ceIpTables;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getSuperAddress() {
        return this.superAddress;
    }

    public String getSuperPassword() {
        return this.superPassword;
    }
}

