/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.api;

import cn.tdchain.api.config.SystemConfig;
import cn.tdchain.api.rpc.CeConnection;
import cn.tdchain.api.rpc.CeConnectionUtils;
import cn.tdchain.api.service.AccountService;
import cn.tdchain.api.service.impl.AccountServiceImpl;
import cn.tdchain.cb.constant.ResultConstants;
import cn.tdchain.cb.exception.BusinessException;
import cn.tdchain.cb.util.StringUtils;
import cn.tdchain.jbcc.rpc.RPCMessage;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;

public class AccountApi {
    private AccountService accountService = new AccountServiceImpl();
    private CeConnection con = CeConnectionUtils.getConnection();

    public void overrideSuper(String address, String password) throws BusinessException {
        if (address.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)address));
        }
        SystemConfig.getInstance().overrideSuper(address, password);
    }

    public Map<String, String> createSuperAccount() throws BusinessException {
        return this.accountService.createSuper();
    }

    public Map<String, String> create(String ksPassword, String crypto, String info) throws BusinessException {
        return this.accountService.create(ksPassword, crypto, info);
    }

    public Map<String, String> freeze(String address, String ksPassword, String freezeAddr) throws BusinessException {
        if (StringUtils.isBlank((String)address) || StringUtils.isBlank((String)ksPassword) || StringUtils.isBlank((String)freezeAddr)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (address.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)address));
        }
        if (freezeAddr.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)freezeAddr));
        }
        RPCMessage msg = this.con.getMessage();
        msg.getCommand().put("address", address);
        msg.getCommand().put("ksPassword", ksPassword);
        msg.getCommand().put("frozenAddress", freezeAddr);
        msg.setTargetType(RPCMessage.TargetType.FREEZE_ACCOUNT);
        return this.con.sendAndReturn(msg, "Failed to freeze account.");
    }

    public Map<String, String> unfreeze(String address, String ksPassword, String unfreezeAddr) throws BusinessException {
        if (StringUtils.isBlank((String)address) || StringUtils.isBlank((String)ksPassword) || StringUtils.isBlank((String)unfreezeAddr)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (address.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)address));
        }
        if (unfreezeAddr.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)unfreezeAddr));
        }
        RPCMessage msg = this.con.getMessage();
        msg.getCommand().put("address", address);
        msg.getCommand().put("ksPassword", ksPassword);
        msg.getCommand().put("unfreezeAddr", unfreezeAddr);
        msg.setTargetType(RPCMessage.TargetType.UNFREEZE_ACCOUNT);
        return this.con.sendAndReturn(msg, "Failed to unfreeze account.");
    }

    public Map<String, String> updateInfo(String address, String ksPassword, String userInfo) throws BusinessException {
        if (address.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)address));
        }
        String encryptInfo = this.accountService.encryptInfo(address, ksPassword, userInfo);
        RPCMessage msg = this.con.getMessage();
        msg.getCommand().put("address", address);
        msg.getCommand().put("ksPassword", ksPassword);
        msg.getCommand().put("userInfo", userInfo);
        msg.getCommand().put("encryptInfo", encryptInfo);
        msg.setTargetType(RPCMessage.TargetType.UPDATE_INFO);
        return this.con.sendAndReturn(msg, "Failed to update account.");
    }

    public Map<String, String> updateAuth(String address, String ksPassword, String modifiedAddr, String authStr) throws BusinessException {
        if (StringUtils.isBlank((String)address) || StringUtils.isBlank((String)ksPassword) || StringUtils.isBlank((String)modifiedAddr) || StringUtils.isBlank((String)authStr)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (address.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)address));
        }
        if (modifiedAddr.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)modifiedAddr));
        }
        RPCMessage msg = this.con.getMessage();
        msg.getCommand().put("address", address);
        msg.getCommand().put("ksPassword", ksPassword);
        msg.getCommand().put("modifiedAddr", modifiedAddr);
        msg.getCommand().put("authStr", authStr);
        msg.setTargetType(RPCMessage.TargetType.UPDATE_AUTH);
        return this.con.sendAndReturn(msg, "Failed to update authority.");
    }

    public String queryUserInfo(String address, String ksPassword) throws BusinessException {
        return this.accountService.findInfo(address, ksPassword);
    }

    public List<JSONObject> queryAccountHistory(String address) throws BusinessException {
        return this.accountService.queryHistory(address);
    }

    public JSONObject findLatestAccount(String address) throws BusinessException {
        return this.accountService.findLatestWithoutKs(address);
    }

    public List<String> queryContractNamesByOwner(String address) throws BusinessException {
        return this.accountService.queryContractNames(address);
    }

    public List<String> queryTemplateNamesByOwner(String address) throws BusinessException {
        return this.accountService.queryTemplateNames(address);
    }

    public List<JSONObject> queryLedger(String address) throws BusinessException {
        return this.accountService.queryLedger(address);
    }

    public List<JSONObject> queryLedgerHistory(String address, String contractName) throws BusinessException {
        return this.accountService.queryLedgerHistory(address, contractName);
    }

    public List<JSONObject> queryLedgerHistoryEx(String address, String contractName) throws BusinessException {
        return this.accountService.queryLedgerHistoryEx(address, contractName);
    }
}

