/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.api.rpc;

import cn.tdchain.Trans;
import cn.tdchain.api.config.SystemConfig;
import cn.tdchain.api.rpc.CeNioNet;
import cn.tdchain.cb.constant.ResultConstants;
import cn.tdchain.cb.domain.ContractState;
import cn.tdchain.cb.exception.BusinessException;
import cn.tdchain.cb.util.CollectionUtils;
import cn.tdchain.cb.util.ConnectionUtils;
import cn.tdchain.cb.util.JsonUtils;
import cn.tdchain.cb.util.StringUtils;
import cn.tdchain.cb.util.TdcbConfig;
import cn.tdchain.jbcc.BatchTrans;
import cn.tdchain.jbcc.Connection;
import cn.tdchain.jbcc.DateUtils;
import cn.tdchain.jbcc.PBFT;
import cn.tdchain.jbcc.ParameterException;
import cn.tdchain.jbcc.Result;
import cn.tdchain.jbcc.net.Net;
import cn.tdchain.jbcc.net.info.Node;
import cn.tdchain.jbcc.rpc.RPCBatchResult;
import cn.tdchain.jbcc.rpc.RPCMessage;
import com.alibaba.fastjson.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CeConnection {
    private static final Logger log = LogManager.getLogger((String)"TD_API");
    private static final ScheduledExecutorService SCHEDULED_SERVICE = Executors.newSingleThreadScheduledExecutor();
    private static final int DEFAULT_TIMEOUT = 5000;
    private String connectionId = UUID.randomUUID().toString();
    private Net net;
    private Connection con = ConnectionUtils.getConnection();
    private int minSucces = 1;

    public CeConnection() {
        String token = TdcbConfig.getInstance().getConnectionToken();
        if (token == null || token.length() == 0) {
            throw new ParameterException("token is null");
        }
        this.minSucces = PBFT.getMinByCount((int)SystemConfig.getInstance().getCeIpTables().length);
        this.net = new CeNioNet(SystemConfig.getInstance().getCeIpTables(), TdcbConfig.getInstance().getCePort(), TdcbConfig.getInstance().getCipher(), token, TdcbConfig.getInstance().getKey(), this.connectionId);
        log.info("Start net.");
        log.info("Try to connect nodes: {}", (Object)JsonUtils.toJson((Object)SystemConfig.getInstance().getCeIpTables()));
        this.net.start();
        while (true) {
            if (this.net.getTaskSize() >= SystemConfig.getInstance().getCeIpTables().length) break;
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        log.info("Complete to connect {} CE nodes.", (Object)this.net.getTaskSize());
        this.asynAskNodes();
    }

    public Connection getCon() {
        return this.con;
    }

    private void asynAskNodes() {
        log.info("Start to sync CE nodes.");
        SCHEDULED_SERVICE.scheduleAtFixedRate(() -> {
            try {
                RPCMessage msg = this.getMessage();
                msg.setTargetType(RPCMessage.TargetType.REQUEST_NODE);
                msg.setMessageId(UUID.randomUUID().toString());
                this.net.request(msg);
                log.info("[{}] request node.", (Object)msg.getMessageId());
                RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), 5000L);
                if (batchResult.isFail()) {
                    batchResult.getResult();
                    return;
                }
                List rpcResultList = batchResult.buildList((TypeReference)new TypeReference<Node>(){});
                for (Result result : rpcResultList) {
                    Node node;
                    if (result == null || !result.isSuccess() || result.getEntity() == null || (node = (Node)result.getEntity()) == null) continue;
                    log.info("copy ce node id: {}, status={}", (Object)node.getId(), (Object)node.getStatus());
                    this.net.addNodeToNodes(node);
                }
                Thread.sleep(1L);
            }
            catch (Exception e) {
                log.error("sync ce nodes get error:{}", (Object)e.getMessage());
            }
        }, 0L, 3L, TimeUnit.SECONDS);
    }

    public RPCMessage getMessage() {
        RPCMessage msg = new RPCMessage();
        msg.setSender(this.connectionId);
        msg.setMessageId(UUID.randomUUID().toString());
        msg.setCommand(new HashMap());
        msg.getCommand().put("timestamp", DateUtils.getCurrentTime().toString());
        return msg;
    }

    public String queryAndReturn(RPCMessage msg) throws BusinessException {
        log.info("[{}] send query request.", (Object)msg.getTargetType().toString());
        this.net.request(msg);
        return this.responseQuery(msg);
    }

    private String responseQuery(RPCMessage msg) throws BusinessException {
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), (long)SystemConfig.getInstance().getTimeout());
        List rpcResultList = batchResult.buildList((TypeReference)new TypeReference<String>(){});
        log.info("[{}] query response: {}", (Object)msg.getTargetType().toString(), (Object)rpcResultList.size());
        int failCount = 0;
        ArrayList<String> errorMessage = new ArrayList<String>();
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        for (int i = 0; i < rpcResultList.size(); ++i) {
            Result rpcResult = (Result)rpcResultList.get(i);
            if (!rpcResult.isSuccess()) {
                if (!errorMessage.contains(rpcResult.getMsg())) {
                    errorMessage.add(rpcResult.getMsg());
                }
                ++failCount;
                continue;
            }
            String entity = (String)rpcResult.getEntity();
            if (StringUtils.isBlank((String)entity)) {
                if (!errorMessage.contains("Null.")) {
                    errorMessage.add("Null.");
                }
                ++failCount;
                continue;
            }
            count.putIfAbsent(entity, 0);
            count.put(entity, (Integer)count.get(entity) + 1);
        }
        if (failCount >= this.minSucces) {
            log.error("{} {} error msg: {}", (Object)"Failed to get consensus result.", (Object)failCount, (Object)((Object)errorMessage).toString());
            throw new BusinessException(((Object)errorMessage).toString());
        }
        for (Map.Entry entry : count.entrySet()) {
            if ((Integer)entry.getValue() < this.minSucces) continue;
            return (String)entry.getKey();
        }
        log.error("{} error msg: {}", (Object)"Failed to get consensus result.", (Object)((Object)errorMessage).toString());
        log.error("========================");
        log.error(JsonUtils.toJson(count));
        log.error("========================");
        throw new BusinessException("Failed to get consensus result.");
    }

    public Map<String, String> sendAndReturn(RPCMessage msg, String failedMessage) throws BusinessException {
        log.info("[{}][{}] send request.", (Object)msg.getMessageId(), (Object)msg.getTargetType().toString());
        log.info("Dest nodes: ");
        log.info(this.net.getNodes().stream().map(Node::getId).collect(Collectors.joining(";")));
        this.net.request(msg);
        return this.response(msg, failedMessage);
    }

    private Map<String, String> response(RPCMessage msg, String failedKey) throws BusinessException {
        RPCBatchResult batchResult = this.net.resphone(msg.getMessageId(), (long)SystemConfig.getInstance().getTimeout());
        List rpcResultList = batchResult.buildList((TypeReference)new TypeReference<List<Trans>>(){});
        log.info("[{}][{}] ceconnection response: {}", (Object)msg.getMessageId(), (Object)msg.getTargetType().toString(), (Object)rpcResultList.size());
        int failCount = 0;
        HashMap errMsg = new HashMap();
        HashMap<Integer, Integer> count = new HashMap<Integer, Integer>();
        HashMap<Integer, List<Trans>> sta = new HashMap<Integer, List<Trans>>();
        for (int i = 0; i < rpcResultList.size(); ++i) {
            Result rpcResult = (Result)rpcResultList.get(i);
            if (!rpcResult.isSuccess()) {
                errMsg.putIfAbsent(rpcResult.getMsg(), new ArrayList());
                ((List)errMsg.get(rpcResult.getMsg())).add(String.valueOf(i));
                ++failCount;
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)rpcResult.getEntity()))) {
                errMsg.putIfAbsent("Null.", new ArrayList());
                ((List)errMsg.get("Null.")).add(String.valueOf(i));
                ++failCount;
                continue;
            }
            this.statistic(i, (List)rpcResult.getEntity(), count, sta);
        }
        if (failCount >= this.minSucces) {
            log.error("======================== [{}][{}] FAILED", (Object)msg.getMessageId(), (Object)msg.getTargetType().toString());
            for (Map.Entry entry : errMsg.entrySet()) {
                log.error((String)entry.getKey() + ":");
                log.error(JsonUtils.toJson(entry.getValue()));
            }
            log.error("========================");
            throw new BusinessException(ResultConstants.getFailedMsg((String)failedKey, (String)errMsg.keySet().toString()));
        }
        List<Trans> txs = this.getPbft(count, sta);
        if (CollectionUtils.isEmpty(txs)) {
            log.error("======================== [{}][{}] FAILED", (Object)msg.getMessageId(), (Object)msg.getTargetType().toString());
            if (CollectionUtils.isNotEmpty(errMsg)) {
                log.error(JsonUtils.toJson(errMsg));
            }
            if (CollectionUtils.isNotEmpty(count)) {
                log.error(JsonUtils.toJson(count));
            }
            if (CollectionUtils.isNotEmpty(sta)) {
                log.error(JsonUtils.toJson(sta));
            }
            log.error("========================");
            throw new BusinessException("Failed to get consensus result.");
        }
        log.debug("******************************");
        log.debug(JsonUtils.toJson(txs));
        log.debug("******************************");
        BatchTrans batch = new BatchTrans();
        batch.addTransToBatch(txs);
        Result backBatch = null;
        if (this.con.startTransaction(batch.keyToArray())) {
            backBatch = this.con.addBatchTrans(batch);
            this.con.stopTransaction(batch.keyToArray());
        }
        if (backBatch == null) {
            throw new BusinessException("Null result.");
        }
        if (backBatch.isTimeout()) {
            throw new BusinessException("Storage timeout, please re-check your record.");
        }
        if (backBatch.isFail()) {
            String failedMsg = ResultConstants.getFailedMsg((String)failedKey, (String)backBatch.getMsg());
            log.error("======================== [{}][{}] FAILED", (Object)msg.getMessageId(), (Object)msg.getTargetType().toString());
            log.error(failedMsg);
            throw new BusinessException(failedMsg);
        }
        if (backBatch.isSuccess() && backBatch.getEntity() != null) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            ((BatchTrans)backBatch.getEntity()).getTransSet().forEach(tx -> {
                String type = tx.getType().split("_")[0];
                resultMap.put(type, tx.getHash());
            });
            for (Trans trans : txs) {
                ContractState contract;
                if (!trans.getType().startsWith("CS_") && !StringUtils.isNotBlank((String)trans.getData()) || (contract = (ContractState)JsonUtils.fromJson((String)trans.getData(), ContractState.class)) == null || !contract.getOprMap().containsKey("RUN_RESULT")) continue;
                resultMap.put("CR", JsonUtils.toJson(contract.getOprMap().get("RUN_RESULT")));
                break;
            }
            log.info("======================== [{}][{}] SUCCESS", (Object)msg.getMessageId(), (Object)msg.getTargetType().toString());
            log.info(JsonUtils.toJson(resultMap));
            return resultMap;
        }
        throw new BusinessException("Failed to store on chain.");
    }

    private List<Trans> getPbft(Map<Integer, Integer> count, Map<Integer, List<Trans>> sta) {
        Integer selectNo = null;
        for (Map.Entry<Integer, Integer> entry : count.entrySet()) {
            if (entry.getValue() < this.minSucces) continue;
            selectNo = entry.getKey();
            break;
        }
        if (selectNo != null) {
            return sta.get(selectNo);
        }
        return null;
    }

    private void statistic(int no, List<Trans> tmp, Map<Integer, Integer> count, Map<Integer, List<Trans>> sta) {
        if (CollectionUtils.isEmpty(count)) {
            count.put(no, 1);
            sta.put(no, tmp);
            return;
        }
        boolean matchFlag = false;
        for (Map.Entry<Integer, List<Trans>> entry : sta.entrySet()) {
            int i;
            Integer num = entry.getKey();
            List<Trans> staTrans = entry.getValue();
            if (staTrans.size() != tmp.size()) continue;
            boolean inconsistent = false;
            for (i = 0; i < staTrans.size(); ++i) {
                if (staTrans.get(i).getHash().equals(tmp.get(i).getHash())) continue;
                inconsistent = true;
                break;
            }
            if (inconsistent) continue;
            matchFlag = true;
            count.put(num, count.get(num) + 1);
            for (i = 0; i < staTrans.size(); ++i) {
                Iterator iterator = tmp.get(i).getSignMap().entrySet().iterator();
                if (!iterator.hasNext()) continue;
                Map.Entry tmpEntry = iterator.next();
                if (staTrans.get(i).getSignMap() == null) {
                    staTrans.get(i).setSignMap(new HashMap());
                }
                staTrans.get(i).getSignMap().put(tmpEntry.getKey(), tmpEntry.getValue());
            }
        }
        if (!matchFlag) {
            count.put(no, 1);
            sta.put(no, tmp);
        }
    }

    public Result<Trans> getNewTransByKey(String key) {
        return this.con.getNewTransByKey(key);
    }

    public Result<List<Trans>> getTransListByType(String type) {
        return this.con.getTransListByType(type);
    }

    public Result<Integer> getTransCountByType(String type) {
        return this.con.getTransCountByAccountAndType(this.con.getAccount(), type);
    }

    public Result<Trans> getTransByHash(String hash) {
        return this.con.getTransByHash(hash);
    }

    public Result<List<Trans>> getTransHistoryByKey(String key) {
        return this.con.getTransHistoryByKey(key, 0, 19);
    }
}

