package cn.tdchain.api.config;

import java.util.List;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;

/**
 * System Configuration Utility. 
 *
 * @version 1.0
 * @author Bingoer.H 2018-11-27
 */
public class SystemConfig {

    private static volatile SystemConfig instance;
    private static final String SYSTEM_CONFIG_FILE = "tdcb.conf";

    private String[] ceIpTables;

    private int timeout;

    private void init() {
        Config config = ConfigFactory.load(SYSTEM_CONFIG_FILE);

        List<String> iplist = config.getStringList("tdcb.connection.ce.iptables");
        ceIpTables = new String[iplist.size()];
        iplist.toArray(ceIpTables);

        timeout = config.getInt("tdcb.connection.timeout");

    }

    /**
     * Get instance.
     * 
     * @return instance
     */
    public static synchronized SystemConfig getInstance() {
        if (instance == null) {
            instance = new SystemConfig();
            instance.init();
        }
        return instance;
    }

    public String[] getCeIpTables() {
        return ceIpTables;
    }

    public int getTimeout() {
        return timeout;
    }

}
