/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.api;

import cn.tdchain.api.rpc.CeConnection;
import cn.tdchain.api.rpc.CeConnectionUtils;
import cn.tdchain.api.service.TemplateService;
import cn.tdchain.api.service.impl.TemplateServiceImpl;
import cn.tdchain.cb.constant.ResultConstants;
import cn.tdchain.cb.domain.Template;
import cn.tdchain.cb.exception.BusinessException;
import cn.tdchain.cb.util.StringUtils;
import cn.tdchain.jbcc.rpc.RPCMessage;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;

public class TemplateApi {
    private TemplateService templateService = new TemplateServiceImpl();
    private CeConnection con = CeConnectionUtils.getConnection();

    public Map<String, String> create(String name, String description, String address, String ksPassword, String javaClassName, String templateSourceCode) throws BusinessException {
        if (StringUtils.isBlank((String)name) || StringUtils.isBlank((String)address) || StringUtils.isBlank((String)ksPassword) || StringUtils.isBlank((String)javaClassName) || StringUtils.isBlank((String)templateSourceCode)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (name.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)name));
        }
        if (address.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)address));
        }
        RPCMessage msg = this.con.getMessage();
        msg.getCommand().put("name", name);
        msg.getCommand().put("description", description);
        msg.getCommand().put("address", address);
        msg.getCommand().put("ksPassword", ksPassword);
        msg.getCommand().put("javaClassName", javaClassName);
        msg.getCommand().put("templateSourceCode", templateSourceCode);
        msg.setTargetType(RPCMessage.TargetType.CREATE_TEMPLATE);
        return this.con.sendAndReturn(msg, "Failed to create template.");
    }

    public Template findByHash(String txHash) throws BusinessException {
        return this.templateService.findByHash(txHash);
    }

    public JSONObject findByName(String name) throws BusinessException {
        return this.templateService.findByName(name);
    }
}

