/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.api.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.List;

public class SystemConfig {
    private static volatile SystemConfig instance;
    private static final String SYSTEM_CONFIG_FILE = "tdcb.conf";
    private String[] ceIpTables;
    private int timeout;

    private void init() {
        Config config = ConfigFactory.load((String)SYSTEM_CONFIG_FILE);
        List iplist = config.getStringList("tdcb.connection.ce.iptables");
        this.ceIpTables = new String[iplist.size()];
        iplist.toArray(this.ceIpTables);
        this.timeout = config.getInt("tdcb.connection.timeout");
    }

    public static synchronized SystemConfig getInstance() {
        if (instance == null) {
            instance = new SystemConfig();
            instance.init();
        }
        return instance;
    }

    public String[] getCeIpTables() {
        return this.ceIpTables;
    }

    public int getTimeout() {
        return this.timeout;
    }
}

