/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.api.rpc;

import cn.tdchain.RPCResultJSONObject;
import cn.tdchain.cipher.Cipher;
import cn.tdchain.cipher.Key;
import cn.tdchain.jbcc.PBFT;
import cn.tdchain.jbcc.Result;
import cn.tdchain.jbcc.net.info.Node;
import cn.tdchain.jbcc.net.nio.NioNet;
import cn.tdchain.jbcc.rpc.RPCBatchResult;
import cn.tdchain.jbcc.rpc.RPCMessage;
import cn.tdchain.jbcc.rpc.RPCResult;
import cn.tdchain.jbcc.rpc.nio.client.NioRpcClient;
import cn.tdchain.jbcc.rpc.nio.client.NioRpcSynResponseClient;
import cn.tdchain.jbcc.rpc.nio.handler.NioRpcChannelFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.CharsetUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CeNioNet
extends NioNet {
    private static final Logger log = LogManager.getLogger((String)"TD_API");
    private final Bootstrap bootstrap;
    private EventLoopGroup workGroup;
    private boolean status = true;
    private HashSet<String> iptables;
    private Hashtable<String, Node> nodes = new Hashtable();
    private int serverPort;
    private Cipher cipher;
    private String token;
    private Key key;
    private String connectionId;
    private int minOnlineNodes = 1;
    private NioRpcChannelFactory nioRpcChannelFactory;
    private Map<String, NioNet.NioTask> taskList = new ConcurrentHashMap<String, NioNet.NioTask>();

    public CeNioNet(String[] iptables, int serverPort, Cipher cipher, String token, Key key, String connectionId) {
        super(iptables, serverPort, cipher, token, key, connectionId);
        this.iptables = new HashSet<String>(Arrays.asList(iptables));
        this.serverPort = serverPort;
        this.cipher = cipher;
        this.token = token;
        this.key = key;
        this.connectionId = connectionId;
        this.bootstrap = new Bootstrap();
        this.workGroup = new NioEventLoopGroup();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.workGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
                ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4)}).addLast(new ChannelHandler[]{new LengthFieldPrepender(4)}).addLast(new ChannelHandler[]{new StringDecoder(CharsetUtil.UTF_8)}).addLast(new ChannelHandler[]{new StringEncoder(CharsetUtil.UTF_8)});
            }
        });
        this.nioRpcChannelFactory = new NioRpcChannelFactory(this.bootstrap);
    }

    public void start() {
        this.asynGetNodesByIpTable();
        new Thread(() -> {
            while (true) {
                if (!this.status) break;
                try {
                    log.info("ce node size=" + this.nodes.size());
                    log.info("ce task size=" + this.taskList.size());
                    this.nodes.forEach((id, node) -> this.startNode((String)id, (Node)node));
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {}
            }
            this.taskList.forEach((k, v) -> v.stop());
        }).start();
    }

    private void startNode(String id, Node node) {
        log.info("serverip={}, status={}", (Object)node.serverIP(), (Object)node.getStatus());
        NioNet.NioTask t = this.taskList.get(id);
        if (t != null && !t.isStatus()) {
            t.stop();
            this.taskList.remove(id);
            t = null;
        }
        if (!Node.NodeStatus.DIE.equals((Object)node.getStatus()) && !Node.NodeStatus.OUT.equals((Object)node.getStatus())) {
            if (t == null && this.taskList.size() < this.iptables.size()) {
                try {
                    t = new NioNet.NioTask((NioNet)this, node.serverIP(), this.serverPort, this.cipher, this.token, this.key, this.connectionId, 1);
                    t.start();
                    this.taskList.put(id, t);
                }
                catch (Exception e) {
                    t = null;
                    log.error("Failed to connect ce node: " + node.serverIP() + " " + e.getMessage(), (Throwable)e);
                    return;
                }
            }
        } else {
            if (t != null && t.isStatus()) {
                t.stop();
                this.taskList.remove(id);
            }
            log.warn("dead node id=" + node.getId());
        }
        if (t != null && !t.isStatus()) {
            t.stop();
            this.taskList.remove(id);
        }
    }

    public void request(RPCMessage msg) {
        this.taskList.forEach((k, v) -> {
            if (v != null && v.isStatus()) {
                msg.setTarget(k);
                v.addRequest(msg.clone());
            } else {
                log.error("Request error {}.", k);
            }
        });
    }

    public RPCBatchResult resphone(String messageId, long timeOut) {
        RPCBatchResult rpcBatchResult = RPCBatchResult.newInstance();
        long start = System.currentTimeMillis();
        log.info("[" + messageId + "] response ce task list: " + this.taskList.size());
        ArrayList tasks = new ArrayList(this.taskList.size() + 3);
        this.taskList.forEach((k, v) -> {
            if (v != null) {
                tasks.add(v);
            }
        });
        log.info("[" + messageId + "] response ce tasks: " + tasks.size());
        while (true) {
            tasks.forEach(v -> {
                RPCResult r;
                if (v != null && (r = v.poll(messageId)) != null) {
                    Result result = new Result();
                    result.setStatus(r.getStatus());
                    result.setEntity(r.getEntity());
                    result.setMsg(r.getMsg());
                    rpcBatchResult.add(result);
                }
            });
            if (rpcBatchResult.size() >= this.iptables.size()) break;
            if (System.currentTimeMillis() - start > timeOut) {
                if (rpcBatchResult.size() >= this.minOnlineNodes) {
                    log.info("[{}] ce result size = {}", (Object)this.serverPort, (Object)rpcBatchResult.size());
                    break;
                }
                rpcBatchResult.isTimeOut(true);
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return rpcBatchResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTaskSize() {
        Map<String, NioNet.NioTask> map = this.taskList;
        synchronized (map) {
            return this.taskList.size();
        }
    }

    public int getMinNodeSize() {
        this.minOnlineNodes = 0;
        this.nodes.forEach((k, v) -> {
            if (v.getStatus() == Node.NodeStatus.METRONOMER) {
                ++this.minOnlineNodes;
            }
        });
        if (this.minOnlineNodes < this.iptables.size()) {
            this.minOnlineNodes = this.iptables.size();
        }
        return PBFT.getMinByCount((int)this.minOnlineNodes);
    }

    public void addNodeToNodes(Node node) {
        if (this.nodes.get(node.getId()) == null) {
            this.nodes.put(node.getId(), node);
        } else {
            Node n = this.nodes.get(node.getId());
            n.setStatus(node.getStatus());
        }
    }

    private void asynGetNodesByIpTable() {
        new Thread(() -> {
            HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
            this.iptables.forEach(ip -> {
                if (ip != null && ip.length() > 0) {
                    flags.put((String)ip, false);
                }
            });
            HashMap clients = new HashMap();
            while (this.status) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                flags.forEach((ip, flag) -> {
                    try {
                        RPCResult r;
                        if (flag.booleanValue()) {
                            return;
                        }
                        NioRpcSynResponseClient client = (NioRpcSynResponseClient)clients.get(ip);
                        if (client == null) {
                            client = new NioRpcSynResponseClient(new NioRpcClient((ChannelFactory)this.nioRpcChannelFactory, ip, this.serverPort, 3000L, this.token, this.connectionId, this.key.getLocalCertBase64String()));
                            if (client.isActive()) {
                                clients.put(ip, client);
                            } else {
                                client.close();
                                client = null;
                                return;
                            }
                        }
                        RPCMessage requestNodeMsg = new RPCMessage();
                        requestNodeMsg.setTarget(ip);
                        requestNodeMsg.setTargetType(RPCMessage.TargetType.REQUEST_NODE);
                        requestNodeMsg.setSender(this.connectionId);
                        String resultStr = client.sendAndReturn(requestNodeMsg.toJsonString(), 5000L);
                        if (resultStr != null && (r = RPCResultJSONObject.parseObject((String)resultStr, Node.class)) != null && r.getEntity() != null) {
                            Node node = (Node)r.getEntity();
                            log.info("\u521d\u6b21\u6536\u5230node=" + node.toJSONString());
                            this.nodes.put(node.getId(), node);
                            client.close();
                            clients.remove(ip);
                            flags.put((String)ip, true);
                        }
                    }
                    catch (Exception e) {
                        log.error("request error server ip={}", ip);
                    }
                });
                Long count = flags.values().stream().filter(value -> value).count();
                if (count.intValue() < this.iptables.size()) continue;
                break;
            }
        }).start();
    }

    public List<Node> getNodes() {
        return this.nodes.entrySet().stream().filter(en -> en.getValue() != null).map(en -> (Node)en.getValue()).collect(Collectors.toList());
    }

    public void stop() {
        this.status = false;
        this.workGroup.shutdownGracefully();
    }
}

