/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.api.service.impl;

import cn.tdchain.Trans;
import cn.tdchain.api.rpc.CeConnection;
import cn.tdchain.api.rpc.CeConnectionUtils;
import cn.tdchain.api.service.TemplateService;
import cn.tdchain.cb.constant.KeyAndType;
import cn.tdchain.cb.constant.ResultConstants;
import cn.tdchain.cb.domain.Template;
import cn.tdchain.cb.exception.BusinessException;
import cn.tdchain.cb.util.JsonUtils;
import cn.tdchain.cb.util.StringUtils;
import cn.tdchain.cb.util.ZipUtils;
import cn.tdchain.jbcc.Result;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TemplateServiceImpl
implements TemplateService {
    private static final Logger log = LogManager.getLogger((String)"TD_API");
    private CeConnection con = CeConnectionUtils.getConnection();

    @Override
    public Template findByHash(String hash) throws BusinessException {
        if (StringUtils.isBlank((String)hash)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        Result<Trans> tx = this.con.getTransByHash(hash);
        if (tx == null) {
            throw new BusinessException("The hash not exists on chain.");
        }
        if (!tx.isSuccess()) {
            throw new BusinessException("Failed to query on chain.");
        }
        if (tx.getEntity() == null || StringUtils.isBlank((String)((Trans)tx.getEntity()).getData())) {
            throw new BusinessException("Not a template record.");
        }
        if (!"T".equals(((Trans)tx.getEntity()).getType())) {
            throw new BusinessException("Not a template record.");
        }
        Template template = (Template)JsonUtils.fromJson((String)((Trans)tx.getEntity()).getData(), Template.class);
        if (template == null) {
            throw new BusinessException("The template does not exist.");
        }
        String zipped = template.getSourceCode();
        try {
            template.setSourceCode(ZipUtils.gUnzip((String)zipped));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return template;
    }

    @Override
    public JSONObject findByName(String templateName) throws BusinessException {
        if (StringUtils.isBlank((String)templateName)) {
            throw new BusinessException("Illegal parameter(s).");
        }
        if (templateName.contains(" ")) {
            throw new BusinessException(ResultConstants.getFailedMsg((String)"Space not allowed: ", (String)templateName));
        }
        Result<Trans> templateTx = this.con.getNewTransByKey(KeyAndType.getTemplateKey((String)templateName));
        if (templateTx == null) {
            throw new BusinessException("The template does not exist.");
        }
        if (!templateTx.isSuccess()) {
            throw new BusinessException("Failed to query on chain.");
        }
        if (templateTx.getEntity() == null || StringUtils.isBlank((String)((Trans)templateTx.getEntity()).getData())) {
            throw new BusinessException("The template does not exist.");
        }
        Template template = (Template)JsonUtils.fromJson((String)((Trans)templateTx.getEntity()).getData(), Template.class);
        if (template == null) {
            throw new BusinessException("The template does not exist.");
        }
        String zipped = template.getSourceCode();
        try {
            template.setSourceCode(ZipUtils.gUnzip((String)zipped));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        JSONObject temp = JSONObject.parseObject((String)template.toString());
        temp.put("hash", (Object)((Trans)templateTx.getEntity()).getHash());
        return temp;
    }
}

