/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cb.util;

import cn.tdchain.Trans;
import cn.tdchain.cb.domain.BaseEntity;
import cn.tdchain.cb.util.CollectionUtils;
import cn.tdchain.cipher.Cipher;
import cn.tdchain.cipher.Key;
import java.util.HashMap;
import java.util.Map;

public class TransUtils {
    private TransUtils() {
    }

    public static Trans createTrans(BaseEntity entity, String account, Long timestamp) {
        return TransUtils.createTrans(entity, account, timestamp, null, -1L);
    }

    public static Trans createTrans(BaseEntity entity, String account, Long timestamp, Long oldVersion) {
        return TransUtils.createTrans(entity, account, timestamp, null, oldVersion);
    }

    public static Trans createTrans(BaseEntity entity, String account, Long timestamp, Map<String, Long> baseMap) {
        return TransUtils.createTrans(entity, account, timestamp, baseMap, -1L);
    }

    public static Trans createTrans(BaseEntity entity, String account, Long timestamp, Map<String, Long> baseMap, Long oldVersion) {
        Trans tx = new Trans();
        tx.setAccount(account);
        tx.setCategory(Trans.Category.contract);
        tx.setKey(entity.getKey());
        tx.setType(entity.getType());
        tx.setData(entity.toString());
        if (CollectionUtils.isNotEmpty(baseMap)) {
            tx.setKeyVersionMap(new HashMap());
            tx.setKeyVersionMap(baseMap);
        }
        tx.setTimestamp(timestamp);
        tx.setVersion(Long.valueOf(oldVersion + 1L));
        tx.upHash();
        return tx;
    }

    public static Trans createSignedTrans(BaseEntity entity, String account, Long timestamp, Cipher cipher, Key key) {
        return TransUtils.createSignedTrans(entity, account, timestamp, null, -1L, cipher, key);
    }

    public static Trans createSignedTrans(BaseEntity entity, String account, Long timestamp, Long oldVersion, Cipher cipher, Key key) {
        return TransUtils.createSignedTrans(entity, account, timestamp, null, oldVersion, cipher, key);
    }

    public static Trans createSignedTrans(BaseEntity entity, String account, Long timestamp, Map<String, Long> baseMap, Cipher cipher, Key key) {
        return TransUtils.createSignedTrans(entity, account, timestamp, baseMap, -1L, cipher, key);
    }

    public static Trans createSignedTrans(BaseEntity entity, String account, Long timestamp, Map<String, Long> baseMap, Long oldVersion, Cipher cipher, Key key) {
        Trans tx = new Trans();
        tx.setAccount(account);
        tx.setCategory(Trans.Category.contract);
        tx.setKey(entity.getKey());
        tx.setType(entity.getType());
        tx.setData(entity.toString());
        if (CollectionUtils.isNotEmpty(baseMap)) {
            tx.setKeyVersionMap(new HashMap());
            tx.setKeyVersionMap(baseMap);
        }
        tx.setTimestamp(timestamp);
        tx.setVersion(Long.valueOf(oldVersion + 1L));
        tx.upHash();
        String signature = cipher.signByPrivateKey(tx.getHash(), key.getPrivateKey());
        tx.setSignMap(new HashMap());
        tx.getSignMap().put(key.getPublicKey(), signature);
        return tx;
    }
}

