/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cb.util;

import cn.tdchain.cb.util.Base64Util;
import cn.tdchain.cb.util.IOUtils;
import cn.tdchain.cb.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ZipUtils {
    private ZipUtils() {
    }

    public static String gzip(String inputStr) throws IOException {
        if (StringUtils.isBlank(inputStr)) {
            return inputStr;
        }
        ByteArrayOutputStream out = null;
        GZIPOutputStream gzip = null;
        try {
            out = new ByteArrayOutputStream();
            gzip = new GZIPOutputStream(out);
            gzip.write(inputStr.getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            IOUtils.close(gzip);
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(gzip);
        IOUtils.close(out);
        return Base64Util.encoder(out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String gUnzip(String compressedStr) throws IOException {
        if (StringUtils.isBlank(compressedStr)) {
            return compressedStr;
        }
        byte[] compressed = Base64Util.byteDecoder(compressedStr);
        String decompressed = null;
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        GZIPInputStream ginzip = null;
        try {
            out = new ByteArrayOutputStream();
            in = new ByteArrayInputStream(compressed);
            ginzip = new GZIPInputStream((InputStream)in, 1024);
            byte[] buffer = new byte[1024];
            int offset = -1;
            while ((offset = ginzip.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
            decompressed = out.toString(StandardCharsets.UTF_8.toString());
        }
        catch (Throwable throwable) {
            IOUtils.close(ginzip);
            IOUtils.close(in);
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(ginzip);
        IOUtils.close(in);
        IOUtils.close(out);
        return decompressed;
    }
}

