package cn.tdchain.cb.domain;

import com.alibaba.fastjson.annotation.JSONField;

import cn.tdchain.cb.constant.KeyAndType;

/**
 * Account.
 * 
 * @version 1.0
 * @author bingoer.H 2018-11-29
 */
public class AccountLedger extends BaseEntity {

    private static final long serialVersionUID = 449732885821610451L;

    private String address;

    private String contractName;

    private String balance;

    private String referenceHash;

    private Long timestamp;

    /**
     * Default constructor.
     */
    public AccountLedger() {
    }

    /**
     * Constructor.
     * 
     * @param address account address
     * @param contractName contract name
     * @param balance account balance
     * @param referenceHash reference contract state transaction hash
     * @param timestamp timestamp
     */
    public AccountLedger(String address, String contractName, String balance,
            String referenceHash, Long timestamp) {
        this.address = address;
        this.contractName = contractName;
        this.balance = balance;
        this.referenceHash = referenceHash;
        this.timestamp = timestamp;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getBalance() {
        return balance;
    }

    public void setBalance(String balance) {
        this.balance = balance;
    }

    public String getReferenceHash() {
        return referenceHash;
    }

    public void setReferenceHash(String referenceHash) {
        this.referenceHash = referenceHash;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @JSONField(serialize = false, deserialize = false)
    @Override
    public String getKey() {
        return KeyAndType.getAccountLedgerKey(this.address, this.contractName);
    }

    @JSONField(serialize = false, deserialize = false)
    @Override
    public String getType() {
        return KeyAndType.getAccountLedgerType(this.address);
    }

}
