package cn.tdchain.cb.domain;

import com.alibaba.fastjson.annotation.JSONField;

import cn.tdchain.cb.constant.KeyAndType;

/**
 * Account.
 * 
 * @version 1.0
 * @author bingoer.H 2018-11-29
 */
public class AccountTemplate extends BaseEntity {

    private static final long serialVersionUID = 449732885821610451L;

    private String address;

    private String templateName;

    /**
     * Default constructor.
     */
    public AccountTemplate() {
    }

    /**
     * Constructor.
     * 
     * @param address String
     * @param templateName String
     */
    public AccountTemplate(String address, String templateName) {
        this.address = address;
        this.templateName = templateName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @JSONField(serialize = false, deserialize = false)
    @Override
    public String getKey() {
        return KeyAndType.getAccountTemplateKey(this.address,
                this.templateName);
    }

    @JSONField(serialize = false, deserialize = false)
    @Override
    public String getType() {
        return KeyAndType.getAccountTemplateType(this.address);
    }

}
