package cn.tdchain.cb.domain;

import java.util.HashMap;
import java.util.Map;

import com.alibaba.fastjson.annotation.JSONField;

import cn.tdchain.cb.constant.KeyAndType;

/**
 * Contract.
 * 
 * @version 1.0
 * @author bingoer.H 2018-12-03
 */
public class ContractState extends BaseEntity {

    private static final long serialVersionUID = -1889099442203320344L;

    private String contractName;

    private String address;

    private String templateName;

    private String compiled;

    private boolean frozen;

    private String operator;

    private ContractOperation operation;

    private Map<String, Object> oprMap;

    /**
     * Default constructor.
     */
    public ContractState() {
    }

    /**
     * Constructor.
     * 
     * @param contractName contract name
     * @param address owner address
     * @param templateName template name
     * @param compiled compiled contract
     * @param operation operation
     */
    public ContractState(String contractName, String address,
            String templateName, String compiled, ContractOperation operation) {
        this.contractName = contractName;
        this.address = address;
        this.operator = address;
        this.templateName = templateName;
        this.compiled = compiled;
        this.operation = operation;
        this.oprMap = new HashMap<String, Object>();
        this.frozen = false;
    }

    /**
     * Constructor.
     * 
     * @param old previous contract state
     * @param compiled compiled contract
     * @param operator operator
     * @param operation operation
     */
    public ContractState(ContractState old, String compiled, String operator,
            ContractOperation operation) {
        this.contractName = old.getContractName();
        this.address = old.getAddress();
        this.templateName = old.getTemplateName();
        this.frozen = old.frozen;
        this.operator = operator;
        this.compiled = compiled;
        this.operation = operation;
        this.oprMap = new HashMap<String, Object>();
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getCompiled() {
        return compiled;
    }

    public void setCompiled(String compiled) {
        this.compiled = compiled;
    }

    public ContractOperation getOperation() {
        return operation;
    }

    public void setOperation(ContractOperation operation) {
        this.operation = operation;
    }

    public boolean isFrozen() {
        return frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Map<String, Object> getOprMap() {
        return oprMap;
    }

    public void setOprMap(Map<String, Object> oprMap) {
        this.oprMap = oprMap;
    }

    /**
     * Put parameter.
     * 
     * @param key String
     * @param value Object
     */
    public void putOprParam(String key, Object value) {
        this.oprMap.put(key, value);
    }

    @JSONField(serialize = false, deserialize = false)
    @Override
    public String getKey() {
        return KeyAndType.getContractStateKey(contractName);
    }

    @JSONField(serialize = false, deserialize = false)
    @Override
    public String getType() {
        return KeyAndType.CS;
    }

}
