package cn.tdchain.cb.service;

import cn.tdchain.cb.exception.BusinessException;

/**
 * Service for Cipher.
 *
 * @version 1.0
 * @author bingoer.H 2018-12-04
 */
public interface CipherService {

    /**
     * Generate key store.
     * 
     * @param crypto "RSA" or "SM"
     * @param ksPassword key store password
     * @return address
     * @throws BusinessException business exception
     */
    String generateKeyStore(String crypto, String ksPassword)
        throws BusinessException;

    /**
     * Get address by public key.
     * 
     * @param crypto "RSA" or "SM"
     * @param publicKey public key
     * @return address
     */
    String getAddress(String crypto, String publicKey);

    /**
     * Get key string.
     * 
     * @param crypto "RSA" or "SM"
     * @param filePath key store file path
     * @param ksPassword key store password
     * @return key string
     * @throws BusinessException business exception
     */
    String getPublicKeyStr(String crypto, String filePath, String ksPassword)
        throws BusinessException;

    /**
     * Get private key string.
     * 
     * @param crypto "RSA" or "SM"
     * @param filePath key store file path
     * @param ksPassword key store password
     * @return private key string
     * @throws BusinessException business exception
     */
    String getPrivateKeyStr(String crypto, String filePath, String ksPassword)
        throws BusinessException;

    /**
     * Encryption.
     * 
     * @param crypto "RSA" or "SM"
     * @param data source data
     * @param publicKeyStr public key string
     * @return encrypted data
     * @throws BusinessException business exception
     */
    String encrypt(String crypto, String data, String publicKeyStr)
        throws BusinessException;

    /**
     * Decryption.
     * 
     * @param crypto "RSA" or "SM"
     * @param data encrypted data
     * @param privateKeyStr private key string
     * @return decrypted data
     * @throws BusinessException business exception
     */
    String decrypt(String crypto, String data, String privateKeyStr)
        throws BusinessException;

}
