package cn.tdchain.cb.util;

import java.io.File;
import java.util.UUID;

import cn.tdchain.cb.constant.Commons;

/**
 * Address Utility.<br>
 * 生成时首先在ksRootPath/tmp/临时目录下创建文件<br>
 * 生成成功后得到address，重命名ks文件放到ksRootPath目录下<br>
 *
 * @version 1.0
 * @author Houmj 2019-01-07
 */
public class AddressUtils {

    private static String ksRootPath = TdcbConfig.getInstance().getAccountKsPath();

    private AddressUtils() {

    }

    /**
     * Get key store file path.
     * 
     * @param address account address
     * @return file path
     */
    public static String getKsFilePath(String address) {
        return ksRootPath + address + Commons.KS;
    }

    /**
     * Get temporary file path.
     * 
     * @return file path
     */
    public static String getTempFilePath() {
        return ksRootPath + Commons.TMP + File.separator
                + UUID.randomUUID().toString() + Commons.KS;
    }

}
