package cn.tdchain.cb.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * IO Utility.
 *
 * @author Houmj 2017-10-19
 * @version 1.0
 */
public final class IOUtils {

    private IOUtils() {
    }

    /**
     * Close InputStream, OutputStream, Reader, Writer, etc.
     *
     * @param closeable InputStream, OutputStream, Reader, Writer, etc
     * @throws IOException IO exception
     */
    public static void close(Closeable closeable) throws IOException {
        if (closeable == null) {
            return;
        }
        closeable.close();
    }

    /**
     * 获得指定文件的字符串.
     * 
     * @param filePath file path
     * @return String
     */
    public static String getBytes(String filePath) {
        File file = new File(filePath);
        try (FileInputStream fis = new FileInputStream(file);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(1000)) {
            byte[] b = new byte[1000];
            int n;
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            byte[] buffer = bos.toByteArray();
            return Base64Util.encoder(buffer);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 根据字符串，生成文件.
     * 
     * @param source file source string
     * @param dir file directory
     * @param filePath directory + file name
     */
    public static void generateFile(String source, String dir,
                                    String filePath) {
        byte[] bfile = Base64Util.byteDecoder(source);
        File file = new File(filePath);
        if(file.exists()){
            file.delete();
        }
        try (FileOutputStream fos = new FileOutputStream(file);
                BufferedOutputStream bos = new BufferedOutputStream(fos)) {
            File file2 = new File(dir);
            if (!file2.exists()) {// 判断文件目录是否存在
                file2.mkdirs();
            }
            bos.write(bfile);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
}
