/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cb.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class StringUtils {
    private static final Charset UTF8 = StandardCharsets.UTF_8;

    private StringUtils() {
    }

    public static String newStr(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, UTF8);
    }

    public static byte[] getBytes(String value) {
        if (value == null) {
            return null;
        }
        return value.getBytes(UTF8);
    }

    public static boolean equals(String s1, String s2) {
        if (StringUtils.isBlank(s1) || StringUtils.isBlank(s2)) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean isBlank(String value) {
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value);
    }

    public static boolean isNotBlank(String value) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)value);
    }

    public static String subString(String value, int start, int end) {
        return org.apache.commons.lang3.StringUtils.substring((String)value, (int)start, (int)end);
    }

    public static String zeroSuffix(String orig, int length) {
        String zeros = org.apache.commons.lang3.StringUtils.repeat((String)"0", (int)length);
        if (StringUtils.isBlank(orig)) {
            return zeros;
        }
        String expendStr = orig + zeros;
        return StringUtils.subString(expendStr, 0, length);
    }

    public static String clearEmptyChar(String text) {
        StringBuilder sb = new StringBuilder();
        for (char c : text.toCharArray()) {
            String ch = String.valueOf(c);
            if (" ".equals(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String zeros(int n) {
        return StringUtils.repeat('0', n);
    }

    public static String repeat(char value, int n) {
        return new String(new char[n]).replace("\u0000", String.valueOf(value));
    }
}

