/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cb.util;

import cn.tdchain.cb.util.StringUtils;
import cn.tdchain.cipher.Cipher;
import cn.tdchain.cipher.CipherException;
import cn.tdchain.cipher.Key;
import cn.tdchain.tdmsp.Msp;
import cn.tdchain.tdmsp.util.PkiUtil;
import java.io.File;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class TdcbConfig {
    public static final int AIO = 1;
    public static final int NIO = 2;
    public static final int IO = 3;
    private static volatile TdcbConfig instance;
    private static PropertiesConfiguration config;
    private static final String SYSTEM_CONFIG_FILE = "tdcb.properties";
    public static final String TOKEN = "tdcb.connection.token";
    public static final String IPTABLE = "tdcb.connection.iptables";
    public static final String PORT = "tdcb.connection.port";
    public static final String CE_PORT = "tdcb.connection.ce.port";
    public static final String CERT_ROOT = "tdcb.cert.root";
    public static final String CERT_LOCAL = "tdcb.cert.local.keystore";
    public static final String CERT_LOCAL_PWD = "tdcb.cert.local.password";
    public static final String KS_PATH = "tdcb.contract.account.kspath";
    private String alias = "tdbc-key";
    private String connectionToken;
    private String[] ipTables;
    private int port;
    private int cePort;
    private String rootKspath;
    private String localKsPath;
    private String localKsPassword;
    private String accountKsPath;
    private Cipher cipher = new Cipher();
    private Key key = new Key();

    private void init() {
        String userJarDir = System.getProperty("user.dir");
        String filePath = userJarDir + "/" + SYSTEM_CONFIG_FILE;
        File file = new File(filePath);
        if (file.exists()) {
            try {
                config = new PropertiesConfiguration(filePath);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("Failed to load " + filePath + ".");
            }
        }
        try {
            config = new PropertiesConfiguration(SYSTEM_CONFIG_FILE);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Failed to load tdcb.properties.");
        }
        this.connectionToken = config.getString(TOKEN);
        String ips = config.getString(IPTABLE);
        if (ips != null && ips.length() > 0) {
            this.ipTables = ips.split(";");
        }
        this.port = config.getInt(PORT);
        this.cePort = config.getInt(CE_PORT);
        if (config.containsKey(CERT_ROOT)) {
            this.rootKspath = config.getString(CERT_ROOT);
        }
        this.localKsPath = config.getString(CERT_LOCAL);
        this.localKsPassword = config.getString(CERT_LOCAL_PWD);
        if (StringUtils.isBlank(this.localKsPath) || StringUtils.isBlank(this.localKsPassword)) {
            throw new RuntimeException("Illegal keystore configuration.");
        }
        this.accountKsPath = config.getString(KS_PATH);
        this.dealKey();
    }

    private void dealKey() {
        try {
            KeyStore keyStore = Msp.getKeyStore((String)this.localKsPath, (String)this.localKsPassword);
            if (keyStore == null) {
                throw new CipherException("Local node KeyStore is null!");
            }
            String privateKey = this.cipher.getPrivateKeyStringByKeyStore(keyStore, this.localKsPassword, Msp.ORGANIZATION_ALIAS);
            String publicKey = this.cipher.getPublicKeyStringByStore(keyStore, this.localKsPassword, Msp.ORGANIZATION_ALIAS);
            if (StringUtils.isBlank(privateKey) || StringUtils.isBlank(publicKey)) {
                throw new RuntimeException("Failed to load key pair: " + this.localKsPath + ".");
            }
            X509Certificate endCert = (X509Certificate)keyStore.getCertificate(Msp.ORGANIZATION_ALIAS);
            String localCertBase64String = Msp.certToBase64String((X509Certificate)endCert);
            this.key.setPrivateKey(privateKey);
            this.key.setPublicKey(publicKey);
            this.key.setLocalCertBase64String(localCertBase64String);
            if (!StringUtils.isBlank(this.rootKspath)) {
                X509Certificate rootCert = PkiUtil.getCertFromCer((String)this.rootKspath);
                String rootCertBase64String = Msp.certToBase64String((X509Certificate)rootCert);
                if (StringUtils.isBlank(rootCertBase64String)) {
                    throw new RuntimeException("Failed to load root cert: " + this.rootKspath + ".");
                }
                this.key.setRootCertBase64String(rootCertBase64String);
            }
        }
        catch (Exception e) {
            throw new CipherException("get private key by key store error:" + e.getMessage());
        }
    }

    public static synchronized TdcbConfig getInstance() {
        if (instance == null) {
            instance = new TdcbConfig();
            instance.init();
        }
        return instance;
    }

    public String getAccountKsPath() {
        return this.accountKsPath;
    }

    public String getLocalKsPath() {
        return this.localKsPath;
    }

    public String getLocalKsPassword() {
        return this.localKsPassword;
    }

    public String getConnectionToken() {
        return this.connectionToken;
    }

    public String[] getIpTables() {
        return this.ipTables;
    }

    public int getPort() {
        return this.port;
    }

    public int getCePort() {
        return this.cePort;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public Key getKey() {
        return this.key;
    }

    public String getAlias() {
        return this.alias;
    }
}

