package cn.tdchain.cb.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * Key and Type.
 *
 * @version 1.0
 * @author Houmj 2019-01-30
 */
public class KeyAndType {

    /* Account Address */
    public static final String ADDR = "ADDR";
    /* Account */
    public static final String A = "A";
    /* Account Template */
    public static final String AT = "AT";
    /* Account Contract */
    public static final String AC = "AC";
    /* Account Ledger */
    public static final String AL = "AL";

    /* Template */
    public static final String T = "T";

    /* Contract */
    public static final String C = "C";
    /* Contract State */
    public static final String CS = "CS";
    
    public static final String CR = "CR";

    /* Normal Record */
    public static final String R = "R";

    public static final String SPLIT = "_";

    public static Map<String, String> descMap = new HashMap<String, String>();
    static {
        descMap.put(ADDR, "Account Address");
        descMap.put(A, "Account Record");
        descMap.put(AT, "Account Template Relationship");
        descMap.put(AC, "Account Contract Relationship");
        descMap.put(AL, "Account Ledger Relationship");
        descMap.put(T, "Template Record");
        descMap.put(C, "Contract Record");
        descMap.put(CS, "Contract Runtime State");
        descMap.put(CR, "Contract Runtime Result");
        descMap.put(R, "Normal Record");
    }

    private KeyAndType() {
    }

    /**
     * Get key for account.
     * 
     * @param address String
     * @return key
     */
    public static String getAccountKey(String address) {
        return A + SPLIT + address;
    }

    /**
     * Get key for account contract.
     * 
     * @param address String
     * @param contractName contract name
     * @return key
     */
    public static String getAccountContractKey(String address,
                                               String contractName) {
        return AC + SPLIT + address + SPLIT + contractName;
    }

    /**
     * Get key for account template.
     * 
     * @param address String
     * @param templateName template name
     * @return key
     */
    public static String getAccountTemplateKey(String address,
                                               String templateName) {
        return AT + SPLIT + address + SPLIT + templateName;
    }

    /**
     * Get key for account ledger.
     * 
     * @param address String
     * @param contractName contract name
     * @return key
     */
    public static String getAccountLedgerKey(String address,
                                             String contractName) {
        return AL + SPLIT + address + SPLIT + contractName;
    }

    /**
     * Get template key.
     * 
     * @param templateName String
     * @return key
     */
    public static String getTemplateKey(String templateName) {
        return T + SPLIT + templateName;
    }

    /**
     * Get contract key.
     * 
     * @param contractName contract name
     * @return key
     */
    public static String getContractKey(String contractName) {
        return C + SPLIT + contractName;
    }

    /**
     * Get contract state key.
     * 
     * @param contractName contract name
     * @return key
     */
    public static String getContractStateKey(String contractName) {
        return CS + SPLIT + contractName;
    }

    /**
     * Get type for account contract.
     * 
     * @param address String
     * @return key
     */
    public static String getAccountContractType(String address) {
        return AC + SPLIT + address;
    }

    /**
     * Get type for account template.
     * 
     * @param address String
     * @return key
     */
    public static String getAccountTemplateType(String address) {
        return AT + SPLIT + address;
    }

    /**
     * Get type for account ledger.
     * 
     * @param address String
     * @return key
     */
    public static String getAccountLedgerType(String address) {
        return AL + SPLIT + address;
    }

    public static Map<String, String> getDescMap() {
        return descMap;
    }

}
