package cn.tdchain.cb.constant;

/**
 * Result Constants.
 *
 * @version 1.0
 * @author Houmj 2019-01-07
 */
public class ResultConstants {

    public static final String PARAM_ILLEGAL = "Illegal parameter(s).";
    public static final String SUPER_REQUIRED = "The operation is only valid for super account.";
    public static final String HIGH_REQUIRED = "The operation is only valid for high or super account.";
    public static final String SUPER_OWNER_REQUIRED = "The operation is only valid for super account or owner.";
    public static final String KS_NOT_MATCH = "Keystore not match.";
    public static final String SUPER_NOT_APPLICABLE = "Super account is not applicable to current scenarios.";
    public static final String SUPER_UPDATE_FAILED = "Cannot update account's authority to SUPER";
    public static final String AUTH_SUPER_ILLEGAL = "Not allowed to modify super account authority.";
    public static final String AUTH_ILLEGAL = "Illegal authority.";
    public static final String AUTH_UPDATE_FAILED = "Failed to update authority.";
    public static final String AUTH_UPDATE_SUCCESS = "Complete to update authority.";
    public static final String KS_PASSWORD_ERROR = "Key store password error.";
    public static final String KEYSTORE_FAILED = "Failed to get keystore.";
    public static final String USERINFO_EN_FAILED = "Failed to encrypt user info.";
    public static final String INFO_EN_ERROR = "Encrypt data not correct.";
    public static final String PRIVATE_KEY_FAILED = "Failed to get private key.";
    public static final String PUBLIC_KEY_FAILED = "Failed to get public key.";
    public static final String ADDRESS_FAILED = "Failed to get address.";
    public static final String CRYPTO_ERROR = "Crypto not supported.";
    public static final String TIMEOUT = "Operation time out.";
    public static final String TIME_FORMAT_ERROR = "Timestamp format: yyyy-MM-dd HH:mm:ss";
    public static final String START_LATER_END = "Start time should be earlier than end time.";
    public static final String SPACE_ILLEGAL = "Space not allowed: ";

    public static final String ACCOUNT_EXISTS = "The account already exists.";
    public static final String ACCOUNT_NOT_EXISTS = "The account does not exist.";
    public static final String ACCOUNT_SUPER_NOT_EXISTS = "The super account does not exist.";
    public static final String ACCOUNT_FROZEN = "The account is frozen.";
    public static final String ACCOUNT_NOT_FROZEN = "The account is not frozen.";
    public static final String ACCOUNT_CREATE_FAILED = "Failed to create account.";
    public static final String ACCOUNT_UPDATE_SUCCESS = "Completed to update account.";
    public static final String ACCOUNT_UPDATE_FAILED = "Failed to update account.";
    public static final String ACCOUNT_FREEZE_SUCCESS = "Complete to freeze account.";
    public static final String ACCOUNT_FREEZE_FAILED = "Failed to freeze account.";
    public static final String ACCOUNT_UNFREEZE_SUCCESS = "Complete to unfreeze account.";
    public static final String ACCOUNT_UNFREEZE_FAILED = "Failed to unfreeze account.";
    public static final String ACCOUNT_INFO_NULL = "Empty user info.";

    public static final String TEMPLATE_EXISTS = "The template already exists.";
    public static final String TEMPLATE_CLASS_EXISTS = "The class already exists.";
    public static final String TEMPLATE_NOT_EXISTS = "The template does not exist.";
    public static final String TEMPLATE_NEW_NOT_EXISTS = "The new template does not exist.";
    public static final String TEMPLATE_OLD_NOT_EXISTS = "The old template does not exist.";
    public static final String TEMPLATE_CREATE_FAILED = "Failed to create template.";
    public static final String COMPILE_FAILED = "Failed to compile class.";

    public static final String ONCHAIN_FAILED = "Failed to store on chain.";
    public static final String ONCHAIN_SUCCESS = "Complete to store on chain.";
    public static final String GETCHAIN_FAILED = "Failed to query on chain.";
    public static final String HASH_NOT_EXISTS = "The hash not exists on chain.";
    public static final String ONCHAIN_TIME_OUT = "Storage timeout, please re-check your record.";

    public static final String CONTRACT_EXISTS = "The contract already exists.";
    public static final String CONTRACT_NOT_EXISTS = "The contract does not exist.";
    public static final String CONTRACT_FROZEN = "The contract is frozen.";
    public static final String CONTRACT_NOT_FROZEN = "The contract is not frozen.";
    public static final String CONTRACT_CREATE_FAILED = "Failed to create contract.";
    public static final String CONTRACT_RUN_FAILED = "Failed to run contract.";
    public static final String CONTRACT_UPDATE_FAILED = "Failed to update contract.";
    public static final String CONTRACT_FREEZE_SUCCESS = "Complete to freeze contract.";
    public static final String CONTRACT_FREEZE_FAILED = "Failed to freeze contract.";
    public static final String CONTRACT_UNFREEZE_SUCCESS = "Complete to unfreeze contract.";
    public static final String CONTRACT_UNFREEZE_FAILED = "Failed to unfreeze contract.";
    public static final String CONTRACT_MIGRATION_FAILED = "Failed to migration contract";
    public static final String CONTRACT_OPR_NOT_OWNER = "The operator is not the owner of the contract.";
    public static final String CONTRACT_UPDATE_MIG_FAILED = "Failed to migration contract attributes.";
    public static final String CONTRACT_RUN_CREATOR_NOT_MATCH = "First parameter should be equal to operator address.";
    public static final String CONTRACT_NAME_NOT_EQUAL = "The 'name' in contract should be equal to contract name.";
    public static final String CONTRACT_NAME_CHANGED = "The 'name' in contract cannot be changed.";
    public static final String CONTRACT_OWNER_CHANGED = "Contract owner cannot be changed.";
    public static final String CONTRACT_OWNER_NOTEXIST = "The contract owner does not exist.";
    public static final String CONTRACT_OWNER_FROZEN = "The contract owner is frozen.";
    public static final String CONTRACT_UNFREEZE_NOTALLOWED = "The operator is not allowed to unfreeze this contract.";

    public static final String BFT_FAILED = "Failed to get consensus result.";
    public static final String NOT_CONTRACT = "Not a contract record.";
    public static final String NOT_CONTRACT_STATE = "Not a contract state record.";
    public static final String NOT_TEMPLATE = "Not a template record.";

    private ResultConstants() {
    }

    /**
     * Return "Account [address] does not exist".
     * 
     * @param address String
     * @return message
     */
    public static String getAccountNotExistsMsg(String address) {
        return "Account " + address + " does not exist.";
    }

    /**
     * Return "Account [address] has bean frozen".
     * 
     * @param address String
     * @return message
     */
    public static String getAccountFrozenMsg(String address) {
        return "Account " + address + " is frozen.";
    }

    /**
     * Get failed message with prefix.
     * 
     * @param pre prefix
     * @param msg message
     * @return failed message
     */
    public static String getFailedMsg(String pre, String msg) {
        return pre + " " + msg;
    }

}
