package cn.tdchain.cb.domain;

import com.alibaba.fastjson.annotation.JSONField;

import cn.tdchain.cb.constant.KeyAndType;

/**
 * Contract Template.
 * 
 * @version 1.0
 * @author bingoer.H 2018-11-29
 */
public class Template extends BaseEntity {

    private static final long serialVersionUID = 2367372090747860683L;

    private String name;

    private String description;

    private String address;

    private String sourceCode;
    
    private Long timestamp;

    private String compiled;

    private String javaClassName;

    /**
     * Default constructor.
     */
    public Template() {
    }

    /**
     * Constructor.
     * 
     * @param name template name
     * @param description template description
     * @param address creator account address
     * @param sourceCode source code
     * @param timestamp create time
     * @param javaClassName java class name
     */
    public Template(String name, String description, String address,
            String sourceCode, String javaClassName, Long timestamp) {
        this.name = name;
        this.description = description;
        this.address = address;
        this.sourceCode = sourceCode;
        this.javaClassName = javaClassName;
        this.timestamp = timestamp;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getCompiled() {
        return compiled;
    }

    public void setCompiled(String compiled) {
        this.compiled = compiled;
    }

    public String getJavaClassName() {
        return javaClassName;
    }

    public void setJavaClassName(String javaClassName) {
        this.javaClassName = javaClassName;
    }

    @JSONField(serialize = false, deserialize = false)
    @Override
    public String getKey() {
        return KeyAndType.getTemplateKey(this.name);
    }

    @JSONField(serialize = false, deserialize = false)
    @Override
    public String getType() {
        return KeyAndType.T;
    }

}
