/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cb.constant;

import java.util.HashMap;
import java.util.Map;

public class KeyAndType {
    public static final String ADDR = "ADDR";
    public static final String A = "A";
    public static final String AT = "AT";
    public static final String AC = "AC";
    public static final String AL = "AL";
    public static final String T = "T";
    public static final String C = "C";
    public static final String CS = "CS";
    public static final String CR = "CR";
    public static final String R = "R";
    public static final String SPLIT = "_";
    public static Map<String, String> descMap = new HashMap<String, String>();

    private KeyAndType() {
    }

    public static String getAccountKey(String address) {
        return "A_" + address;
    }

    public static String getAccountContractKey(String address, String contractName) {
        return "AC_" + address + SPLIT + contractName;
    }

    public static String getAccountTemplateKey(String address, String templateName) {
        return "AT_" + address + SPLIT + templateName;
    }

    public static String getAccountLedgerKey(String address, String contractName) {
        return "AL_" + address + SPLIT + contractName;
    }

    public static String getTemplateKey(String templateName) {
        return "T_" + templateName;
    }

    public static String getContractKey(String contractName) {
        return "C_" + contractName;
    }

    public static String getContractStateKey(String contractName) {
        return "CS_" + contractName;
    }

    public static String getAccountContractType(String address) {
        return "AC_" + address;
    }

    public static String getAccountTemplateType(String address) {
        return "AT_" + address;
    }

    public static String getAccountLedgerType(String address) {
        return "AL_" + address;
    }

    public static Map<String, String> getDescMap() {
        return descMap;
    }

    static {
        descMap.put(ADDR, "Account Address");
        descMap.put(A, "Account Record");
        descMap.put(AT, "Account Template Relationship");
        descMap.put(AC, "Account Contract Relationship");
        descMap.put(AL, "Account Ledger Relationship");
        descMap.put(T, "Template Record");
        descMap.put(C, "Contract Record");
        descMap.put(CS, "Contract Runtime State");
        descMap.put(CR, "Contract Runtime Result");
        descMap.put(R, "Normal Record");
    }
}

