/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cb.service.impl;

import cn.tdchain.cb.exception.BusinessException;
import cn.tdchain.cb.service.CipherService;
import cn.tdchain.cb.util.AddressUtils;
import cn.tdchain.cb.util.Base64Util;
import cn.tdchain.cb.util.StringUtils;
import cn.tdchain.cipher.Cipher;
import java.io.File;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;

public class CipherServiceImpl
implements CipherService {
    private static final int PUBLIC_KEY_SIZE = 64;
    private static final int ADDRESS_SIZE = 160;
    private static final int ADDRESS_LENGTH_IN_HEX = 40;
    private static final int PUBLIC_KEY_LENGTH_IN_HEX = 128;
    private String alias = "tdbc-key";
    private String[] cipherTypes = new String[]{Cipher.Type.RSA.name(), Cipher.Type.SM.name()};
    private Cipher rsaCipher = new Cipher();
    private Cipher smCipher = new Cipher();

    private Cipher getCipher(String crypto) {
        if (Cipher.Type.SM.name().equals(crypto)) {
            return this.smCipher;
        }
        return this.rsaCipher;
    }

    @Override
    public String generateKeyStore(String crypto, String ksPassword) throws BusinessException {
        long duration;
        String tempFilePath;
        File file;
        if (!Arrays.asList(this.cipherTypes).contains(crypto)) {
            throw new BusinessException("Crypto not supported.");
        }
        if (StringUtils.isBlank(ksPassword)) {
            ksPassword = "123456";
        }
        if ((file = new File(tempFilePath = AddressUtils.getTempFilePath())).exists()) {
            file.delete();
        }
        Cipher cipher = this.getCipher(crypto);
        cipher.generateKeyStoreFile(tempFilePath, ksPassword, this.alias);
        LocalDateTime start = LocalDateTime.now();
        do {
            String publicKeyStr;
            if (!file.exists()) continue;
            try {
                publicKeyStr = this.getPublicKey(cipher, tempFilePath, ksPassword);
            }
            catch (Exception e) {
                throw new BusinessException("Failed to get public key.");
            }
            String address = this.getAddress(crypto, publicKeyStr);
            if (StringUtils.isBlank(address)) {
                throw new BusinessException("Failed to get address.");
            }
            boolean rename = file.renameTo(new File(AddressUtils.getKsFilePath(address)));
            System.out.println("Create keystore:" + rename);
            return address;
        } while ((duration = Duration.between(start, LocalDateTime.now()).toMillis()) <= 3000L);
        throw new BusinessException("Operation time out.");
    }

    @Override
    public String getAddress(String crypto, String publicKey) {
        Cipher cipher;
        String hash;
        if (StringUtils.isBlank(crypto) || StringUtils.isBlank(publicKey)) {
            return null;
        }
        if (!Arrays.asList(this.cipherTypes).contains(crypto)) {
            return null;
        }
        if (publicKey.length() < 128) {
            publicKey = StringUtils.zeros(128 - publicKey.length()) + publicKey;
        }
        if ((hash = (cipher = this.getCipher(crypto)).hash(publicKey)) == null) {
            return null;
        }
        return hash.substring(hash.length() - 40);
    }

    @Override
    public String getPublicKeyStr(String crypto, String filePath, String ksPassword) throws BusinessException {
        if (StringUtils.isBlank(crypto) || StringUtils.isBlank(filePath) || StringUtils.isBlank(ksPassword)) {
            throw new BusinessException("Failed to get public key.");
        }
        if (!Arrays.asList(this.cipherTypes).contains(crypto)) {
            throw new BusinessException("Crypto not supported.");
        }
        Cipher cipher = this.getCipher(crypto);
        try {
            return this.getPublicKey(cipher, filePath, ksPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("Failed to get public key.");
        }
    }

    @Override
    public String getPrivateKeyStr(String crypto, String filePath, String ksPassword) {
        if (StringUtils.isBlank(crypto) || StringUtils.isBlank(filePath) || StringUtils.isBlank(ksPassword)) {
            return null;
        }
        if (!Arrays.asList(this.cipherTypes).contains(crypto)) {
            return null;
        }
        Cipher cipher = this.getCipher(crypto);
        try {
            return this.getPrivateKey(cipher, filePath, ksPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String encrypt(String crypto, String data, String publicKeyStr) throws BusinessException {
        if (StringUtils.isBlank(crypto) || StringUtils.isBlank(data) || StringUtils.isBlank(publicKeyStr)) {
            throw new BusinessException("Failed to encrypt user info.");
        }
        Cipher cipher = this.getCipher(crypto);
        return cipher.encryptByPublicKey(data, publicKeyStr);
    }

    @Override
    public String decrypt(String crypto, String data, String privateKeyStr) {
        if (StringUtils.isBlank(crypto) || StringUtils.isBlank(data) || StringUtils.isBlank(privateKeyStr)) {
            return data;
        }
        Cipher cipher = this.getCipher(crypto);
        return cipher.decryptByPrivateKey(data, privateKeyStr);
    }

    private String getPublicKey(Cipher cipher, String ksPath, String ksPwd) throws Exception {
        PublicKey publicKey = cipher.getPublicKeyByStore(ksPath, ksPwd, this.alias);
        return Base64Util.encoder(publicKey.getEncoded());
    }

    private String getPrivateKey(Cipher cipher, String ksPath, String ksPwd) throws Exception {
        PrivateKey privateKey = cipher.getPrivateKeyByKeyStore(ksPath, ksPwd, this.alias);
        return Base64Util.encoder(privateKey.getEncoded());
    }
}

