/*
 * Decompiled with CFR 0.152.
 */
package cn.tdchain.cb.util;

import cn.tdchain.cb.util.StringUtils;
import cn.tdchain.cipher.Cipher;
import cn.tdchain.cipher.CipherException;
import cn.tdchain.cipher.Key;
import cn.tdchain.tdmsp.Msp;
import cn.tdchain.tdmsp.util.PkiUtil;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.security.KeyStore;
import java.security.cert.X509Certificate;

public class TdcbConfig {
    public static final int AIO = 1;
    public static final int NIO = 2;
    public static final int IO = 3;
    private static volatile TdcbConfig instance;
    private static final String SYSTEM_CONFIG_FILE = "tdcb.properties";
    private static final String TOKEN = "tdcb.connection.token";
    private static final String IPTABLE = "tdcb.connection.iptables";
    private static final String PORT = "tdcb.connection.port";
    private static final String CE_PORT = "tdcb.connection.ce.port";
    private static final String SHOW_PRINT = "tdcb.connection.showprint";
    private static final String CERT_ROOT = "tdcb.cert.root";
    private static final String CERT_LOCAL = "tdcb.cert.local.keystore";
    private static final String CERT_LOCAL_PWD = "tdcb.cert.local.password";
    private static final String KS_PATH = "tdcb.contract.account.kspath";
    private String connectionToken;
    private String[] ipTables;
    private int port;
    private int cePort;
    private boolean showPrint = false;
    private String rootKspath;
    private String localKsPath;
    private String localKsPassword;
    private String accountKsPath;
    private Cipher cipher = new Cipher();
    private Key key = new Key();

    private void init() {
        String userJarDir = System.getProperty("user.dir");
        String filePath = userJarDir + "/" + SYSTEM_CONFIG_FILE;
        File file = new File(filePath);
        Config config = file.exists() ? ConfigFactory.parseFile((File)file) : ConfigFactory.load((String)SYSTEM_CONFIG_FILE);
        this.connectionToken = config.getString(TOKEN);
        String ips = config.getString(IPTABLE);
        if (ips != null && ips.length() > 0) {
            this.ipTables = ips.split(";");
        }
        this.port = config.getInt(PORT);
        this.cePort = config.getInt(CE_PORT);
        if (config.hasPath(SHOW_PRINT)) {
            this.showPrint = config.getBoolean(SHOW_PRINT);
        }
        if (config.hasPath(CERT_ROOT)) {
            this.rootKspath = config.getString(CERT_ROOT);
        }
        this.localKsPath = config.getString(CERT_LOCAL);
        this.localKsPassword = config.getString(CERT_LOCAL_PWD);
        if (StringUtils.isBlank(this.localKsPath) || StringUtils.isBlank(this.localKsPassword)) {
            throw new RuntimeException("Illegal keystore configuration.");
        }
        this.accountKsPath = config.getString(KS_PATH);
        this.dealKey();
    }

    private void dealKey() {
        try {
            KeyStore keyStore = Msp.getKeyStore((String)this.localKsPath, (String)this.localKsPassword);
            if (keyStore == null) {
                throw new CipherException("Local node KeyStore is null!");
            }
            String privateKey = this.cipher.getPrivateKeyStringByKeyStore(keyStore, this.localKsPassword, Msp.ORGANIZATION_ALIAS);
            String publicKey = this.cipher.getPublicKeyStringByStore(keyStore, this.localKsPassword, Msp.ORGANIZATION_ALIAS);
            if (StringUtils.isBlank(privateKey) || StringUtils.isBlank(publicKey)) {
                throw new RuntimeException("Failed to load key pair: " + this.localKsPath + ".");
            }
            X509Certificate endCert = (X509Certificate)keyStore.getCertificate(Msp.ORGANIZATION_ALIAS);
            String localCertBase64String = Msp.certToBase64String((X509Certificate)endCert);
            this.key.setPrivateKey(privateKey);
            this.key.setPublicKey(publicKey);
            this.key.setLocalCertBase64String(localCertBase64String);
            if (!StringUtils.isBlank(this.rootKspath)) {
                X509Certificate rootCert = PkiUtil.getCertFromCer((String)this.rootKspath);
                String rootCertBase64String = Msp.certToBase64String((X509Certificate)rootCert);
                if (StringUtils.isBlank(rootCertBase64String)) {
                    throw new RuntimeException("Failed to load root cert: " + this.rootKspath + ".");
                }
                this.key.setRootCertBase64String(rootCertBase64String);
            }
        }
        catch (Exception e) {
            throw new CipherException("get private key by key store error:" + e.getMessage());
        }
    }

    public static synchronized TdcbConfig getInstance() {
        if (instance == null) {
            instance = new TdcbConfig();
            instance.init();
        }
        return instance;
    }

    public String getAccountKsPath() {
        return this.accountKsPath;
    }

    public String getLocalKsPath() {
        return this.localKsPath;
    }

    public String getLocalKsPassword() {
        return this.localKsPassword;
    }

    public String getConnectionToken() {
        return this.connectionToken;
    }

    public String[] getIpTables() {
        return this.ipTables;
    }

    public int getPort() {
        return this.port;
    }

    public int getCePort() {
        return this.cePort;
    }

    public boolean isShowPrint() {
        return this.showPrint;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public Key getKey() {
        return this.key;
    }
}

