package cn.tdchain.cb.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;

/**
 * Date Utilities.
 *
 * @version 1.0
 * @author Administrator 2019-02-22
 */
public class DateUtils {

    public static final String TIME_STAMP_SPACE = "yyyy-MM-dd HH:mm:ss SSS";
    public static final String TIME_STAMP = "yyyy-MM-dd HH:mm:ss";

    private DateUtils() {
    }

    /**
     * Parse date with pattern
     * DateUtils.parseDate("2017-11-11 11:11:11.111", DateUtils.TIME_STAMP)
     * 
     * @param dateString date string
     * @param pattern date pattern
     * @return formatted date
     */
    public static Date parseDate(String dateString, String pattern) {
        Date result = null;
        if (!pattern.contains("y")) {
            dateString = "2000" + dateString;
            pattern = "yyyy" + pattern;
        }
        DateFormat sdf = new SimpleDateFormat(pattern, Locale.CHINA);
        sdf.setLenient(false);
        try {
            result = sdf.parse(dateString);
        } catch (Exception e) {
            result = null;
        }
        return result;
    }

    /**
     * Parse date with pattern
     * DateUtils.parseDate("2017-11-11 11:11:11.111", DateUtils.TIME_STAMP)
     * 
     * @param dateString date string
     * @param pattern date pattern
     * @return formatted date
     */
    public static LocalDateTime parseLocalDateTime(String dateString,
                                                   String pattern) {
        if (!pattern.contains("y")) {
            dateString = "2000" + dateString;
            pattern = "yyyy" + pattern;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern,
                Locale.CHINA);
        return LocalDateTime.parse(dateString, formatter);
    }

}
