package cn.tdchain.cb.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/**
 * Compress Utility.
 *
 * @version 1.0
 * @author Xiaoming 2018-07-04
 */
public class ZipUtils {

    private ZipUtils() {
    }

    /**
     * Gzip.
     * 
     * @param inputStr input string
     * @return zip string
     * @throws IOException exception
     */
    public static String gzip(String inputStr) throws IOException {
        if (StringUtils.isBlank(inputStr)) {
            return inputStr;
        }

        ByteArrayOutputStream out = null;
        GZIPOutputStream gzip = null;

        try {
            out = new ByteArrayOutputStream();
            gzip = new GZIPOutputStream(out);
            gzip.write(inputStr.getBytes(StandardCharsets.UTF_8));
        } finally {
            IOUtils.close(gzip);
            IOUtils.close(out);
        }

        return Base64Util.encoder(out.toByteArray());
    }

    /**
     * Unzip.
     * 
     * @param compressedStr compressed string
     * @return unzip string
     * @throws IOException stream exception
     */
    public static String gUnzip(String compressedStr) throws IOException {
        if (StringUtils.isBlank(compressedStr)) {
            return compressedStr;
        }

        byte[] compressed = Base64Util.byteDecoder(compressedStr);
        String decompressed = null;

        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        GZIPInputStream ginzip = null;
        try {
            out = new ByteArrayOutputStream();
            in = new ByteArrayInputStream(compressed);
            ginzip = new GZIPInputStream(in, 1024);

            byte[] buffer = new byte[1024];
            int offset = -1;
            while ((offset = ginzip.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
            decompressed = out.toString(StandardCharsets.UTF_8.toString());
        } finally {
            IOUtils.close(ginzip);
            IOUtils.close(in);
            IOUtils.close(out);
        }

        return decompressed;
    }

}
