package cn.tenfell.plugins.controllerfree.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="cn.tenfell.plugins.ctrlfree")
@Data
public class ControllerFreeProperties {
    private String password;
    private NeedLogin defaultNeedLogin;
    public enum NeedLogin{
        OPEN("开启"),
        CLOSE("关闭");
        private String name;
        NeedLogin(String name){
            this.name = name;
        }
    }
}
