package cn.tenfell.plugins.controllerfree.controller;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.tenfell.plugins.controllerfree.utilsentity.PoData;
import cn.tenfell.plugins.controllerfree.utilsentity.R;
import cn.tenfell.plugins.controllerfree.component.UriHandComponent;
import cn.tenfell.plugins.controllerfree.config.NoControllerConfiguration;
import cn.tenfell.plugins.controllerfree.inface.NoControllerInterface;
import cn.tenfell.plugins.controllerfree.utils.ToolsUtils;
import cn.tenfell.plugins.controllerfree.utilsentity.UriMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Controller
public class WebController {
    public static Logger Logger = LoggerFactory.getLogger(WebController.class);
    @Autowired
    ApplicationContext ac;
    @Autowired
    NoControllerInterface noControllerInterface;
    @RequestMapping(value = "/selevt/{1}/{2}")
    public void selevt(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Exception e = null;
        try {
            UriMap uriMap= UriHandComponent.handMap.get(request.getRequestURI());
            PoData poData = readRequestData(request);
            checkField(uriMap,poData);
            int length = uriMap.getParams().length;
            if(length == 2){
                uriMap.getMethod().invoke(uriMap.getService(),request,response);
            }else if(length == 3){
                Class clazz = uriMap.getParams()[2];
                uriMap.getMethod().invoke(uriMap.getService(),request,response,dataToBean(poData,clazz));
            }
        } catch (Exception e2) {
            e = e2;
        }
        if(e != null){
            Logger.error(ToolsUtils.getExceptionMessage(e,false),e);
            throw e;
        }
    }
    @RequestMapping(value = "/json/{1}/{2}", produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    public Object json(HttpServletRequest request){
        Object result = actionAjax(request,"json");
        return result;
    }
    @RequestMapping(value = "/jsonp/{1}/{2}", produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    public String jsonp(HttpServletRequest request){
        Object result = actionAjax(request,"jsonp");
        String callback = request.getParameter("callback");
        if(callback == null || "".equals(callback)){
            callback = "callback";
        }
        return callback+"("+ JSONUtil.toJsonStr(result) +")";
    }
    private void checkField(UriMap uriMap,PoData poData){
        List<String> forceFields = uriMap.getForceFields();
        if(forceFields == null || forceFields.size() == 0){
            return;
        }
        String body = poData.getRequestBody();
        if(StrUtil.isNotBlank(body)){
            JSONObject json = JSONUtil.parseObj(body);
            for(String field:forceFields){
                if(StrUtil.isBlank(json.getStr(field))){
                    Assert.isTrue(false,"字段[{}]不可为空",field);
                }
            }
        }else{
            for(String field:forceFields){
                if(StrUtil.isBlank(poData.getStr(field))){
                    Assert.isTrue(false,"字段[{}]不可为空",field);
                }
            }
        }
    }
    private Object actionAjax(HttpServletRequest request,String type){
        PoData poData = readRequestData(request);
        if(StrUtil.equals(type,"jsonp")){
            poData.remove("callback");
        }
        Object result = null;
        try {
            UriMap uriMap= UriHandComponent.handMap.get(request.getRequestURI());
            int length = uriMap.getParams().length;
            checkField(uriMap,poData);
            if(length == 1){
                result =uriMap.getMethod().invoke(uriMap.getService(),poData);
            }else if(length == 2){
                Class clazz = uriMap.getParams()[1];
                result =uriMap.getMethod().invoke(uriMap.getService(),poData,dataToBean(poData,clazz));
            }
        } catch (Exception e) {
            Logger.error(ToolsUtils.getExceptionMessage(e,false),e);
            result = R.error(e);
        }
        return result;
    }
    @RequestMapping(value = UriHandComponent.INTERFACE_URI, produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    public R doclist(HttpServletRequest request){
        PoData res = UriHandComponent.getDocData();
        if(StrUtil.isBlank(NoControllerConfiguration.password)){
            return R.okData(res);
        }
        String key = request.getParameter("key");
        if(StrUtil.isBlank(key)){
            return R.failed("请输入密码");
        }
        if(!NoControllerConfiguration.password.equals(key)){
            return R.failed("请输入密码");
        }
        return R.okData(res);
    }

    private static PoData readRequestData(HttpServletRequest request){
        PoData poData = PoData.create();
        poData.putAll(ServletUtil.getParamMap(request));
        String requestBody = ServletUtil.getBody(request);
        if(StrUtil.isNotBlank(requestBody)){
            poData.setRequestBody(requestBody);
        }
        return poData;
    }
    private static <T> T dataToBean(PoData data,Class clazz){
        try{
            String requestBody = data.getRequestBody();
            if(StrUtil.isNotBlank(requestBody)){
                return (T)JSONUtil.toBean(requestBody,clazz);
            }
            return (T)data.toBean(clazz);
        }catch (Exception e){
            return null;
        }
    }
}

