package cn.tenfell.plugins.controllerfree.component;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.tenfell.plugins.controllerfree.annotation.*;
import cn.tenfell.plugins.controllerfree.config.ControllerFreeProperties;
import cn.tenfell.plugins.controllerfree.config.NoControllerConfiguration;
import cn.tenfell.plugins.controllerfree.inface.NoControllerInterface;
import cn.tenfell.plugins.controllerfree.utils.AopTargetUtils;
import cn.tenfell.plugins.controllerfree.entity.*;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.*;

@Component
public class UriHandComponent implements ApplicationContextAware {
    private static InterfaceDoc defInterfaceDoc;
    private static List<InterfaceDocEntity> interfaceList;
    private static Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
    private static String interfaceCreateTime;
    public static final Map<String, UriMap> handMap = new HashMap<>();
    public static final String INTERFACE_URI = "/interface/doclist";
    private static NoControllerInterface noControllerInterface;
    private static ControllerFreeProperties controllerFreeProperties;
    private static ApplicationContext applicationContext;
    private static Map<String, ServiceCacheData> serviceCacheDataMap = new HashMap<>();
    public static NoControllerInterface getNoControllerInterface(){
        return noControllerInterface;
    }
    public static Validator getValidator(){
        return validator;
    }
    public static PoData getDocData(){
        PoData data = PoData.create()
                .set("list",UriHandComponent.interfaceList)
                .set("time",UriHandComponent.interfaceCreateTime);
        return data;
    }
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        UriHandComponent.applicationContext = applicationContext;
        try{
            NoControllerInterface noControllerInterface = applicationContext.getBean(NoControllerInterface.class);
            UriHandComponent.noControllerInterface = noControllerInterface;
        }catch (NoSuchBeanDefinitionException e){
            throw new RuntimeException("请用Spring组件实现NoControllerInterface接口",e);
        }
        try{
            ControllerFreeProperties controllerFreeProperties = applicationContext.getBean(ControllerFreeProperties.class);
            UriHandComponent.controllerFreeProperties = controllerFreeProperties;
        }catch (NoSuchBeanDefinitionException e){
            throw new RuntimeException("配置项读取异常",e);
        }
        NoControllerConfiguration.password = controllerFreeProperties.getPassword();
        try{
            defInterfaceDoc = EmptyClass.class.getDeclaredMethod("emptyMethod").getAnnotation(InterfaceDoc.class);
        }catch (Exception e){

        }
        updateHandMap(null);
    }
    private static void updateHandMapOneService(Object service,String key){
        String[] conMappings = {"json","jsonp"};
        //原对象,用于获取注解
        Object serviceTarget = AopTargetUtils.getTarget(service);
        ServiceCacheData serviceCacheData = new ServiceCacheData();
        serviceCacheData.setService(serviceTarget);
        serviceCacheData.setServiceName(key);
        List<Method> methodList = new ArrayList<Method>();
        Method[] methods = serviceTarget.getClass().getDeclaredMethods();
        for(Method method:methods){
            Class<?>[] types = method.getParameterTypes();
            boolean hasMethod = false;
            int type = getType(types);
            if(type == 1){
                hasMethod = true;
                //表示要处理的json,jsonp
                UriMap uriMap = new UriMap();
                uriMap.setService(service);
                uriMap.setMethod(method);
                uriMap.setParams(types);
                NeedLogin needLogin = method.getAnnotation(NeedLogin.class);
                NotNeedLogin notNeedLogin = method.getAnnotation(NotNeedLogin.class);
                uriMap.setNeedLogin(getNeedLogin(needLogin,notNeedLogin));
                for(String conMapping:conMappings){
                    String mapKey = "/"+conMapping+"/"+key+"/"+method.getName();
                    handMap.put(mapKey,uriMap);
                }
            }else if(type == 2){
                hasMethod = true;
                //表示要处理的selevt
                UriMap uriMap = new UriMap();
                uriMap.setService(service);
                uriMap.setMethod(method);
                uriMap.setParams(types);
                NeedLogin needLogin = method.getAnnotation(NeedLogin.class);
                NotNeedLogin notNeedLogin = method.getAnnotation(NotNeedLogin.class);
                uriMap.setNeedLogin(getNeedLogin(needLogin,notNeedLogin));
                String mapKey = "/selevt/"+key+"/"+method.getName();
                handMap.put(mapKey,uriMap);
            }
            if(hasMethod){
                methodList.add(method);
            }
        }
        serviceCacheData.setMethods(methodList);
        serviceCacheDataMap.put(key,serviceCacheData);
    }
    private static boolean getNeedLogin(NeedLogin needLogin,NotNeedLogin notNeedLogin){
        if((needLogin != null && notNeedLogin != null) || (needLogin == null && notNeedLogin == null)){
            ControllerFreeProperties.NeedLogin need = controllerFreeProperties.getDefaultNeedLogin();
            return need == ControllerFreeProperties.NeedLogin.OPEN;
        }else if(needLogin != null){
            return true;
        }
        return false;
    }
    public static void updateHandMap(String serviceName){
        Map<String, Object> serviceMap =  applicationContext.getBeansWithAnnotation(Service.class);
        if(StrUtil.isBlank(serviceName)){
            /*初始化*/
            Set<String> keys = serviceMap.keySet();
            for(String key:keys){
                Object service = serviceMap.get(key);
                updateHandMapOneService(service,key);
            }
        }else{
            /*更新*/
            Object service = serviceMap.get(serviceName);
            if(service == null){
                return;
            }
            updateHandMapOneService(service,serviceName);
        }
        ThreadUtil.execute(new Runnable() {
            @Override
            public void run() {
                updateInterfaceList();
            }
        });
    }
    private static void updateInterfaceList(){
        interfaceList = new ArrayList<>();
        String[] conMappings = {"json","jsonp"};
        Set<String> keys = serviceCacheDataMap.keySet();
        for(String key:keys){
            ServiceCacheData serviceCacheData = serviceCacheDataMap.get(key);
            InterfaceDocEntity interfaceDocEntity = null;
            List<InterfaceDocChild> interfaceDocChildren = null;
            Object service = serviceCacheData.getService();
            List<Method> methodList = serviceCacheData.getMethods();
            for(Method method:methodList){
                Class<?>[] types = method.getParameterTypes();
                InterfaceDoc interfaceDoc = method.getAnnotation(InterfaceDoc.class);
                if(interfaceDoc == null){
                    interfaceDoc = defInterfaceDoc;
                }
                int type = getType(types);
                boolean hasDoc = type==1 || type==2;
                if(!hasDoc){
                    continue;
                }
                if(interfaceDocEntity == null){
                    interfaceDocEntity = new InterfaceDocEntity();
                    interfaceDocChildren = new ArrayList<InterfaceDocChild>();
                    String moduleName = serviceCacheData.getServiceName();
                    InterfaceModule interfaceModule = service.getClass().getAnnotation(InterfaceModule.class);
                    if(interfaceModule != null && !"".equals(interfaceModule.value())){
                        moduleName = interfaceModule.value();
                    }
                    interfaceDocEntity.setName(moduleName);
                }
                InterfaceDocChild interfaceDocChild = new InterfaceDocChild();
                String interfaceName = method.getName();
                if(!"".equals(interfaceDoc.name())){
                    interfaceName = interfaceDoc.name();
                }
                interfaceDocChild.setName(interfaceName);
                List<InterfaceParams> interfaceParamsList = new ArrayList<InterfaceParams>();
                List<String> forceFields = new ArrayList<>();
                Class clazz = interfaceDoc.entity();
                String checkType;//0为params校验 1为实体校验
                Class entity = null;//实体校验类型
                Class[] checkGroups = null;//实体校验组
                if(clazz != EmptyClass.class){
                    /**
                     * 通过实体来校验字段
                     */
                    checkType = "1";
                    entity = clazz;
                    Field[] fields = clazz.getDeclaredFields();
                    Map<String,String> fieldMap = new HashMap<>();
                    for(Field field:fields){
                        InterfaceField ifi = field.getAnnotation(InterfaceField.class);
                        if(ifi != null){
                            fieldMap.put(field.getName(),ifi.value());
                        }
                    }
                    Class[] groups = interfaceDoc.groups();
                    checkGroups = groups;
                    BeanDescriptor beanDescriptor = validator.getConstraintsForClass(clazz);
                    if(beanDescriptor != null){
                        Set<PropertyDescriptor> sets = beanDescriptor.getConstrainedProperties();
                        for(PropertyDescriptor prop:sets){
                            String field = prop.getPropertyName();
                            String descr = "";
                            if (fieldMap.get(field) != null){
                                descr = fieldMap.get(field);
                                fieldMap.remove(field);
                            }
                            boolean forceIs = false;
                            Set<ConstraintDescriptor<?>> cds = prop.getConstraintDescriptors();
                            for(ConstraintDescriptor cd:cds){
                                Class annClass =  cd.getAnnotation().annotationType();
                                if(annClass != NotBlank.class && annClass != NotEmpty.class){
                                    continue;
                                }
                                Set<Class<?>>  cgroups = cd.getGroups();
                                if(cgroups.size() == 0 && groups.length == 0){
                                    forceIs = true;
                                    break;
                                }
                                for(Class group:groups){
                                    if(cgroups.contains(group)){
                                        forceIs = true;
                                        break;
                                    }
                                }
                                if(forceIs){
                                    break;
                                }
                            }
                            InterfaceParams interfaceParams = new InterfaceParams();
                            interfaceParams.setParam(field);
                            interfaceParams.setForceIs(forceIs);
                            if(forceIs){
                                forceFields.add(field);
                            }
                            interfaceParams.setParamDesc(descr);
                            interfaceParamsList.add(interfaceParams);
                        }
                    }
                    Set<String> sets = fieldMap.keySet();
                    for(String set:sets){
                        InterfaceParams interfaceParams = new InterfaceParams();
                        interfaceParams.setParam(set);
                        interfaceParams.setForceIs(false);
                        interfaceParams.setParamDesc(fieldMap.get(set));
                        interfaceParamsList.add(interfaceParams);
                    }
                }else{
                    /**
                     * 通过params来校验字段
                     */
                    checkType = "0";
                    InterfaceForm[] params = interfaceDoc.params();
                    for(InterfaceForm param:params){
                        if(param == null || "".equals(param.field())){
                            continue;
                        }
                        InterfaceParams interfaceParams = new InterfaceParams();
                        interfaceParams.setParam(param.field());
                        interfaceParams.setForceIs(param.force());
                        if(param.force()){
                            forceFields.add(param.field());
                        }
                        interfaceParams.setParamDesc(param.descr());
                        interfaceParamsList.add(interfaceParams);
                    }
                }
                interfaceDocChild.setParams(interfaceParamsList);
                List<String> urlList = new ArrayList<String>();
                if(type == 1){
                    //表示要处理的json,jsonp
                    for(String conMapping:conMappings){
                        String mapKey = "/"+conMapping+"/"+serviceCacheData.getServiceName()+"/"+method.getName();
                        urlList.add(mapKey);
                        UriMap uriMap = handMap.get(mapKey);
                        if(uriMap != null){
                            uriMap.setForceFields(forceFields);
                            uriMap.setCheckType(checkType);
                            uriMap.setEntity(entity);
                            uriMap.setGroups(checkGroups);
                        }
                    }
                }else if(type == 2){
                    //表示要处理的selevt
                    String mapKey = "/selevt/"+serviceCacheData.getServiceName()+"/"+method.getName();
                    urlList.add(mapKey);
                    UriMap uriMap = handMap.get(mapKey);
                    if(uriMap != null){
                        uriMap.setForceFields(forceFields);
                        uriMap.setCheckType(checkType);
                        uriMap.setEntity(entity);
                        uriMap.setGroups(checkGroups);
                    }
                }
                interfaceDocChild.setUrlList(urlList);
                interfaceDocChildren.add(interfaceDocChild);
            }
            if(interfaceDocEntity != null){
                interfaceDocEntity.setList(interfaceDocChildren);
                interfaceList.add(interfaceDocEntity);
            }
        }
        interfaceCreateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }
    private static int getType(Class<?>[] types){
        int type = 0;
        if((types.length == 1 || types.length == 2) && types[0] == PoData.class){
            type = 1;
        }else if((types.length == 2 || types.length == 3) && types[0] == HttpServletRequest.class && types[1] == HttpServletResponse.class){
            type = 2;
        }
        return type;
    }

}

