/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.plugins.controllerfree.component;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.tenfell.plugins.controllerfree.annotation.InterfaceDoc;
import cn.tenfell.plugins.controllerfree.annotation.InterfaceField;
import cn.tenfell.plugins.controllerfree.annotation.InterfaceForm;
import cn.tenfell.plugins.controllerfree.annotation.InterfaceModule;
import cn.tenfell.plugins.controllerfree.annotation.NeedLogin;
import cn.tenfell.plugins.controllerfree.annotation.NotNeedLogin;
import cn.tenfell.plugins.controllerfree.config.ControllerFreeProperties;
import cn.tenfell.plugins.controllerfree.config.NoControllerConfiguration;
import cn.tenfell.plugins.controllerfree.entity.EmptyClass;
import cn.tenfell.plugins.controllerfree.entity.InterfaceDocChild;
import cn.tenfell.plugins.controllerfree.entity.InterfaceDocEntity;
import cn.tenfell.plugins.controllerfree.entity.InterfaceParams;
import cn.tenfell.plugins.controllerfree.entity.PoData;
import cn.tenfell.plugins.controllerfree.entity.ServiceCacheData;
import cn.tenfell.plugins.controllerfree.entity.UriMap;
import cn.tenfell.plugins.controllerfree.inface.NoControllerInterface;
import cn.tenfell.plugins.controllerfree.utils.AopTargetUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
public class UriHandComponent
implements ApplicationContextAware {
    private static InterfaceDoc defInterfaceDoc;
    private static List<InterfaceDocEntity> interfaceList;
    private static Validator validator;
    private static String interfaceCreateTime;
    public static final Map<String, UriMap> handMap;
    public static final String INTERFACE_URI = "/interface/doclist";
    private static NoControllerInterface noControllerInterface;
    private static ControllerFreeProperties controllerFreeProperties;
    private static ApplicationContext applicationContext;
    private static Map<String, ServiceCacheData> serviceCacheDataMap;

    public static NoControllerInterface getNoControllerInterface() {
        return noControllerInterface;
    }

    public static Validator getValidator() {
        return validator;
    }

    public static PoData getDocData() {
        PoData data = PoData.create().set("list", interfaceList).set("time", interfaceCreateTime);
        return data;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        UriHandComponent.applicationContext = applicationContext;
        try {
            NoControllerInterface noControllerInterface;
            UriHandComponent.noControllerInterface = noControllerInterface = (NoControllerInterface)applicationContext.getBean(NoControllerInterface.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new RuntimeException("\u8bf7\u7528Spring\u7ec4\u4ef6\u5b9e\u73b0NoControllerInterface\u63a5\u53e3", e);
        }
        try {
            ControllerFreeProperties controllerFreeProperties;
            UriHandComponent.controllerFreeProperties = controllerFreeProperties = (ControllerFreeProperties)applicationContext.getBean(ControllerFreeProperties.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new RuntimeException("\u914d\u7f6e\u9879\u8bfb\u53d6\u5f02\u5e38", e);
        }
        NoControllerConfiguration.password = controllerFreeProperties.getPassword();
        try {
            defInterfaceDoc = EmptyClass.class.getDeclaredMethod("emptyMethod", new Class[0]).getAnnotation(InterfaceDoc.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        UriHandComponent.updateHandMap(null);
    }

    private static void updateHandMapOneService(Object service, String key) {
        Method[] methods;
        String[] conMappings = new String[]{"json", "jsonp"};
        Object serviceTarget = AopTargetUtils.getTarget(service);
        ServiceCacheData serviceCacheData = new ServiceCacheData();
        serviceCacheData.setService(serviceTarget);
        serviceCacheData.setServiceName(key);
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method method : methods = serviceTarget.getClass().getDeclaredMethods()) {
            NotNeedLogin notNeedLogin;
            NeedLogin needLogin;
            UriMap uriMap;
            Class<?>[] types = method.getParameterTypes();
            boolean hasMethod = false;
            int type = UriHandComponent.getType(types);
            if (type == 1) {
                hasMethod = true;
                uriMap = new UriMap();
                uriMap.setService(service);
                uriMap.setMethod(method);
                uriMap.setParams(types);
                needLogin = method.getAnnotation(NeedLogin.class);
                notNeedLogin = method.getAnnotation(NotNeedLogin.class);
                uriMap.setNeedLogin(UriHandComponent.getNeedLogin(needLogin, notNeedLogin));
                for (String conMapping : conMappings) {
                    String mapKey = "/" + conMapping + "/" + key + "/" + method.getName();
                    handMap.put(mapKey, uriMap);
                }
            } else if (type == 2) {
                hasMethod = true;
                uriMap = new UriMap();
                uriMap.setService(service);
                uriMap.setMethod(method);
                uriMap.setParams(types);
                needLogin = method.getAnnotation(NeedLogin.class);
                notNeedLogin = method.getAnnotation(NotNeedLogin.class);
                uriMap.setNeedLogin(UriHandComponent.getNeedLogin(needLogin, notNeedLogin));
                String mapKey = "/selevt/" + key + "/" + method.getName();
                handMap.put(mapKey, uriMap);
            }
            if (!hasMethod) continue;
            methodList.add(method);
        }
        serviceCacheData.setMethods(methodList);
        serviceCacheDataMap.put(key, serviceCacheData);
    }

    private static boolean getNeedLogin(NeedLogin needLogin, NotNeedLogin notNeedLogin) {
        if (needLogin != null && notNeedLogin != null || needLogin == null && notNeedLogin == null) {
            ControllerFreeProperties.NeedLogin need = controllerFreeProperties.getDefaultNeedLogin();
            return need == ControllerFreeProperties.NeedLogin.OPEN;
        }
        return needLogin != null;
    }

    public static void updateHandMap(String serviceName) {
        Map serviceMap = applicationContext.getBeansWithAnnotation(Service.class);
        if (StrUtil.isBlank((CharSequence)serviceName)) {
            Set keys = serviceMap.keySet();
            for (String key : keys) {
                Object service = serviceMap.get(key);
                UriHandComponent.updateHandMapOneService(service, key);
            }
        } else {
            Object service = serviceMap.get(serviceName);
            if (service == null) {
                return;
            }
            UriHandComponent.updateHandMapOneService(service, serviceName);
        }
        ThreadUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                UriHandComponent.updateInterfaceList();
            }
        });
    }

    private static void updateInterfaceList() {
        interfaceList = new ArrayList<InterfaceDocEntity>();
        String[] conMappings = new String[]{"json", "jsonp"};
        Set<String> keys = serviceCacheDataMap.keySet();
        for (String key : keys) {
            ServiceCacheData serviceCacheData = serviceCacheDataMap.get(key);
            InterfaceDocEntity interfaceDocEntity = null;
            ArrayList<InterfaceDocChild> interfaceDocChildren = null;
            Object service = serviceCacheData.getService();
            List<Method> methodList = serviceCacheData.getMethods();
            for (Method method : methodList) {
                String checkType;
                int type;
                boolean hasDoc;
                Class<?>[] types = method.getParameterTypes();
                InterfaceDoc interfaceDoc = method.getAnnotation(InterfaceDoc.class);
                if (interfaceDoc == null) {
                    interfaceDoc = defInterfaceDoc;
                }
                if (!(hasDoc = (type = UriHandComponent.getType(types)) == 1 || type == 2)) continue;
                if (interfaceDocEntity == null) {
                    interfaceDocEntity = new InterfaceDocEntity();
                    interfaceDocChildren = new ArrayList<InterfaceDocChild>();
                    String moduleName = serviceCacheData.getServiceName();
                    InterfaceModule interfaceModule = service.getClass().getAnnotation(InterfaceModule.class);
                    if (interfaceModule != null && !"".equals(interfaceModule.value())) {
                        moduleName = interfaceModule.value();
                    }
                    interfaceDocEntity.setName(moduleName);
                }
                InterfaceDocChild interfaceDocChild = new InterfaceDocChild();
                String interfaceName = method.getName();
                if (!"".equals(interfaceDoc.name())) {
                    interfaceName = interfaceDoc.name();
                }
                interfaceDocChild.setName(interfaceName);
                ArrayList<InterfaceParams> interfaceParamsList = new ArrayList<InterfaceParams>();
                ArrayList<String> forceFields = new ArrayList<String>();
                Class clazz = interfaceDoc.entity();
                Class entity = null;
                Class[] checkGroups = null;
                if (clazz != EmptyClass.class) {
                    Class[] groups;
                    checkType = "1";
                    entity = clazz;
                    Field[] fields = clazz.getDeclaredFields();
                    HashMap fieldMap = new HashMap();
                    for (Field field : fields) {
                        InterfaceField ifi = field.getAnnotation(InterfaceField.class);
                        if (ifi == null) continue;
                        fieldMap.put(field.getName(), ifi.value());
                    }
                    checkGroups = groups = interfaceDoc.groups();
                    BeanDescriptor beanDescriptor = validator.getConstraintsForClass(clazz);
                    if (beanDescriptor != null) {
                        Set sets = beanDescriptor.getConstrainedProperties();
                        for (PropertyDescriptor prop : sets) {
                            String field3 = prop.getPropertyName();
                            String descr = "";
                            if (fieldMap.get(field3) != null) {
                                descr = (String)fieldMap.get(field3);
                                fieldMap.remove(field3);
                            }
                            boolean forceIs = false;
                            Set cds = prop.getConstraintDescriptors();
                            for (ConstraintDescriptor cd : cds) {
                                Class<? extends Annotation> annClass = cd.getAnnotation().annotationType();
                                if (annClass != NotBlank.class && annClass != NotEmpty.class) continue;
                                Set cgroups = cd.getGroups();
                                if (cgroups.size() == 0 && groups.length == 0) {
                                    forceIs = true;
                                    break;
                                }
                                for (Class group : groups) {
                                    if (!cgroups.contains(group)) continue;
                                    forceIs = true;
                                    break;
                                }
                                if (!forceIs) continue;
                                break;
                            }
                            InterfaceParams interfaceParams = new InterfaceParams();
                            interfaceParams.setParam(field3);
                            interfaceParams.setForceIs(forceIs);
                            if (forceIs) {
                                forceFields.add(field3);
                            }
                            interfaceParams.setParamDesc(descr);
                            interfaceParamsList.add(interfaceParams);
                        }
                    }
                    Set sets = fieldMap.keySet();
                    for (String set : sets) {
                        InterfaceParams interfaceParams = new InterfaceParams();
                        interfaceParams.setParam(set);
                        interfaceParams.setForceIs(false);
                        interfaceParams.setParamDesc((String)fieldMap.get(set));
                        interfaceParamsList.add(interfaceParams);
                    }
                } else {
                    checkType = "0";
                    InterfaceForm[] params = interfaceDoc.params();
                    for (InterfaceForm param : params) {
                        if (param == null || "".equals(param.field())) continue;
                        InterfaceParams interfaceParams = new InterfaceParams();
                        interfaceParams.setParam(param.field());
                        interfaceParams.setForceIs(param.force());
                        if (param.force()) {
                            forceFields.add(param.field());
                        }
                        interfaceParams.setParamDesc(param.descr());
                        interfaceParamsList.add(interfaceParams);
                    }
                }
                interfaceDocChild.setParams(interfaceParamsList);
                ArrayList<String> urlList = new ArrayList<String>();
                if (type == 1) {
                    for (String conMapping : conMappings) {
                        String string = "/" + (String)conMapping + "/" + serviceCacheData.getServiceName() + "/" + method.getName();
                        urlList.add(string);
                        UriMap uriMap = handMap.get(string);
                        if (uriMap == null) continue;
                        uriMap.setForceFields(forceFields);
                        uriMap.setCheckType(checkType);
                        uriMap.setEntity(entity);
                        uriMap.setGroups(checkGroups);
                    }
                } else if (type == 2) {
                    String mapKey = "/selevt/" + serviceCacheData.getServiceName() + "/" + method.getName();
                    urlList.add(mapKey);
                    UriMap uriMap = handMap.get(mapKey);
                    if (uriMap != null) {
                        uriMap.setForceFields(forceFields);
                        uriMap.setCheckType(checkType);
                        uriMap.setEntity(entity);
                        uriMap.setGroups(checkGroups);
                    }
                }
                interfaceDocChild.setUrlList(urlList);
                interfaceDocChildren.add(interfaceDocChild);
            }
            if (interfaceDocEntity == null) continue;
            interfaceDocEntity.setList(interfaceDocChildren);
            interfaceList.add(interfaceDocEntity);
        }
        interfaceCreateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }

    private static int getType(Class<?>[] types) {
        int type = 0;
        if ((types.length == 1 || types.length == 2) && types[0] == PoData.class) {
            type = 1;
        } else if ((types.length == 2 || types.length == 3) && types[0] == HttpServletRequest.class && types[1] == HttpServletResponse.class) {
            type = 2;
        }
        return type;
    }

    static {
        validator = Validation.buildDefaultValidatorFactory().getValidator();
        handMap = new HashMap<String, UriMap>();
        serviceCacheDataMap = new HashMap<String, ServiceCacheData>();
    }
}

