/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.plugins.controllerfree.controller;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.tenfell.plugins.controllerfree.component.UriHandComponent;
import cn.tenfell.plugins.controllerfree.config.NoControllerConfiguration;
import cn.tenfell.plugins.controllerfree.entity.PoData;
import cn.tenfell.plugins.controllerfree.entity.R;
import cn.tenfell.plugins.controllerfree.entity.UriMap;
import cn.tenfell.plugins.controllerfree.inface.NoControllerInterface;
import cn.tenfell.plugins.controllerfree.utils.ToolsUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WebController {
    public static Logger Logger = LoggerFactory.getLogger(WebController.class);
    @Autowired
    ApplicationContext ac;
    @Autowired
    NoControllerInterface noControllerInterface;

    @RequestMapping(value={"/selevt/{1}/{2}"})
    public void selevt(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Exception e = null;
        try {
            UriMap uriMap = UriHandComponent.handMap.get(request.getRequestURI());
            PoData poData = WebController.readRequestData(request);
            this.checkField(uriMap, poData);
            int length = uriMap.getParams().length;
            if (length == 2) {
                uriMap.getMethod().invoke(uriMap.getService(), request, response);
            } else if (length == 3) {
                Class<?> clazz = uriMap.getParams()[2];
                uriMap.getMethod().invoke(uriMap.getService(), request, response, WebController.dataToBean(poData, clazz));
            }
        }
        catch (Exception e2) {
            e = e2;
        }
        if (e != null) {
            Logger.error(ToolsUtils.getExceptionMessage(e, false), (Throwable)e);
            throw e;
        }
    }

    @RequestMapping(value={"/json/{1}/{2}"}, produces={"application/json"})
    @ResponseBody
    public Object json(HttpServletRequest request) {
        Object result = this.actionAjax(request, "json");
        return result;
    }

    @RequestMapping(value={"/jsonp/{1}/{2}"}, produces={"application/json"})
    @ResponseBody
    public String jsonp(HttpServletRequest request) {
        Object result = this.actionAjax(request, "jsonp");
        String callback = request.getParameter("callback");
        if (callback == null || "".equals(callback)) {
            callback = "callback";
        }
        return callback + "(" + JSONUtil.toJsonStr((Object)result) + ")";
    }

    private void checkField(UriMap uriMap, PoData poData) {
        List<String> forceFields = uriMap.getForceFields();
        if (forceFields == null || forceFields.size() == 0) {
            return;
        }
        if ("0".equals(uriMap.getCheckType())) {
            String body = poData.getRequestBody();
            if (StrUtil.isNotBlank((CharSequence)body)) {
                JSONObject json = JSONUtil.parseObj((String)body);
                for (String field : forceFields) {
                    if (!StrUtil.isBlank((CharSequence)json.getStr((Object)field))) continue;
                    Assert.isTrue((boolean)false, (String)"\u5b57\u6bb5[{}]\u4e0d\u53ef\u4e3a\u7a7a", (Object[])new Object[]{field});
                }
            } else {
                for (String field : forceFields) {
                    if (!StrUtil.isBlank((CharSequence)poData.getStr(field))) continue;
                    Assert.isTrue((boolean)false, (String)"\u5b57\u6bb5[{}]\u4e0d\u53ef\u4e3a\u7a7a", (Object[])new Object[]{field});
                }
            }
        } else if ("1".equals(uriMap.getCheckType())) {
            String body = poData.getRequestBody();
            Class clazz = uriMap.getEntity();
            Object t = null;
            if (StrUtil.isNotBlank((CharSequence)body)) {
                JSONObject json = JSONUtil.parseObj((String)body);
                t = json.toBean(clazz);
            } else {
                t = poData.toBean(clazz);
            }
            Assert.notNull((Object)t, (String)"\u6821\u9a8c\u5b9e\u4f53\u4e0d\u53ef\u4e3a\u7a7a", (Object[])new Object[0]);
            Validator validator = UriHandComponent.getValidator();
            Set set = validator.validate(t, uriMap.getGroups());
            if (set.size() == 0) {
                return;
            }
            Assert.isTrue((boolean)false, (String)((ConstraintViolation)set.iterator().next()).getMessage(), (Object[])new Object[0]);
        }
    }

    private Object actionAjax(HttpServletRequest request, String type) {
        Object result;
        block7: {
            PoData poData = WebController.readRequestData(request);
            if (StrUtil.equals((CharSequence)type, (CharSequence)"jsonp")) {
                poData.remove("callback");
            }
            result = null;
            try {
                UriMap uriMap = UriHandComponent.handMap.get(request.getRequestURI());
                int length = uriMap.getParams().length;
                this.checkField(uriMap, poData);
                if (length == 1) {
                    result = uriMap.getMethod().invoke(uriMap.getService(), new Object[]{poData});
                } else if (length == 2) {
                    Class<?> clazz = uriMap.getParams()[1];
                    result = uriMap.getMethod().invoke(uriMap.getService(), new Object[]{poData, WebController.dataToBean(poData, clazz)});
                }
            }
            catch (Throwable e) {
                while (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                Logger.error(ToolsUtils.getExceptionMessage(e, false), e);
                result = this.noControllerInterface.errorHandler(e);
                if (result != null) break block7;
                result = R.error(e);
            }
        }
        return result;
    }

    @RequestMapping(value={"/interface/doclist"}, produces={"application/json"})
    @ResponseBody
    public R doclist(HttpServletRequest request) {
        PoData res = UriHandComponent.getDocData();
        if (StrUtil.isBlank((CharSequence)NoControllerConfiguration.password)) {
            return R.okData(res);
        }
        String key = request.getParameter("key");
        if (StrUtil.isBlank((CharSequence)key)) {
            return R.failed("\u8bf7\u8f93\u5165\u5bc6\u7801");
        }
        if (!NoControllerConfiguration.password.equals(key)) {
            return R.failed("\u8bf7\u8f93\u5165\u5bc6\u7801");
        }
        return R.okData(res);
    }

    private static PoData readRequestData(HttpServletRequest request) {
        PoData poData = PoData.create();
        poData.putAll(ServletUtil.getParamMap((ServletRequest)request));
        String requestBody = ServletUtil.getBody((ServletRequest)request);
        if (StrUtil.isNotBlank((CharSequence)requestBody)) {
            poData.setRequestBody(requestBody);
        }
        return poData;
    }

    private static <T> T dataToBean(PoData data, Class clazz) {
        try {
            String requestBody = data.getRequestBody();
            if (StrUtil.isNotBlank((CharSequence)requestBody)) {
                return (T)JSONUtil.toBean((String)requestBody, (Class)clazz);
            }
            return (T)data.toBean(clazz);
        }
        catch (Exception e) {
            return null;
        }
    }
}

