package cn.tenfell.plugins.controllerfree.config;

import cn.tenfell.plugins.controllerfree.filter.LoginHandlerInterceptor;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.ArrayList;
import java.util.List;

@Configuration
@ComponentScan(basePackages="cn.tenfell.plugins.controllerfree"+"*..*")
public class NoControllerConfiguration implements WebMvcConfigurer {
    public static String password;
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        List<String> list = new ArrayList<String>();
        list.add("/**/*.*");
        registry.addInterceptor(new LoginHandlerInterceptor()).excludePathPatterns(list);
    }
    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/**").addResourceLocations("classpath:/static/");
    }
}
