package cn.tenfell.plugins.controllerfree.filter;

import cn.tenfell.plugins.controllerfree.component.UriHandComponent;
import cn.tenfell.plugins.controllerfree.controller.WebController;
import cn.tenfell.plugins.controllerfree.entity.R;
import cn.tenfell.plugins.controllerfree.utils.ToolsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class BaseWebExceptionHandler {
    public static Logger Logger = LoggerFactory.getLogger(WebController.class);
    @ExceptionHandler(Exception.class)
    Object exception(Exception e){
        Object result = UriHandComponent.getNoControllerInterface().errorHandler(e);
        if(result == null){
            result = R.error(e);
        }
        Logger.error(ToolsUtils.getExceptionMessage(e,true),e);
        return result;
    }
}
