package cn.tenfell.plugins.controllerfree.filter;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import cn.tenfell.plugins.controllerfree.component.UriHandComponent;
import cn.tenfell.plugins.controllerfree.entity.R;
import cn.tenfell.plugins.controllerfree.entity.ResponseStatus;
import cn.tenfell.plugins.controllerfree.entity.UriMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 接口拦截器
 */
public class LoginHandlerInterceptor implements HandlerInterceptor {
    public static Logger Logger = LoggerFactory.getLogger(LoginHandlerInterceptor.class);
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler){
        UriMap uriMap = getUriMap(request.getRequestURI());
        if(uriMap == null){
            //说明接口不存在
            if(UriHandComponent.INTERFACE_URI.equals(request.getRequestURI())){
                return true;
            }
            try{
                Object noMethod = R.failed("此方法不存在");
                response.setContentType("application/json;charset=UTF-8");
                response.getOutputStream().write(JSONUtil.toJsonStr(noMethod).getBytes());
            }catch (Exception e){
                Logger.error("方法不存在异常");
            }
            return false;
        }
        if(uriMap.isNeedLogin()){
            //说明此接口需要登录
            Object user = UriHandComponent.getNoControllerInterface().getLoginUser(request);
            if(user == null){
                try{
                    Object noLogin = R.failed("用户没有登录").set("status", ResponseStatus.NOLOGIN);
                    response.setContentType("application/json;charset=UTF-8");
                    response.getOutputStream().write(JSONUtil.toJsonStr(noLogin).getBytes());
                }catch (Exception e){
                    Logger.error("用户未登录异常");
                }
                return false;
            }
        }
        return true;
    }

    /**
     * 获取接口缓存map,获取不到进行同步
     * @param uri
     * @return
     */
    private UriMap getUriMap(String uri){
        UriMap uriMap = UriHandComponent.handMap.get(uri);
        if(uriMap == null){
            /**
             * 更新一下map
             */
            String tempStr;
            if(StrUtil.startWith(uri,"/json/")){
                tempStr = uri.substring(6);
            }else if(StrUtil.startWith(uri,"/jsonp/")){
                tempStr = uri.substring(7);
            }else if(StrUtil.startWith(uri,"/selevt/")){
                tempStr = uri.substring(8);
            }else{
                return null;
            }
            int c = tempStr.lastIndexOf("/");
            if(c == -1){
                return null;
            }
            String service = tempStr.substring(0,c);
            if(StrUtil.isBlank(service)){
                return null;
            }
            UriHandComponent.updateHandMap(service);
            uriMap = UriHandComponent.handMap.get(uri);
        }
        return uriMap;
    }
    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) throws Exception {
    }
    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) throws Exception {
    }
}
