package cn.tenfell.plugins.controllerfree.controller;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.tenfell.plugins.controllerfree.component.UriHandComponent;
import cn.tenfell.plugins.controllerfree.config.ControllerFreeProperties;
import cn.tenfell.plugins.controllerfree.entity.PoData;
import cn.tenfell.plugins.controllerfree.entity.R;
import cn.tenfell.plugins.controllerfree.entity.UriMap;
import cn.tenfell.plugins.controllerfree.utils.ToolsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;

/**
 * 通用Controller
 * @author fs
 */
@Controller
public class WebController {
    public static Logger Logger = LoggerFactory.getLogger(WebController.class);
    /**
     * 配置信息
     */
    @Autowired
    ControllerFreeProperties controllerFreeProperties;

    /**
     * selevt接口
     * @param request request
     * @param response response
     * @throws Exception 异常
     */
    @RequestMapping(value = "/selevt/{1}/{2}")
    public void selevt(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Exception e = null;
        try {
            UriMap uriMap= UriHandComponent.handMap.get(request.getRequestURI());
            PoData poData = readRequestData(request);
            checkField(uriMap,poData);
            int length = uriMap.getParams().length;
            if(length == 2){
                uriMap.getMethod().invoke(uriMap.getService(),request,response);
            }else if(length == 3){
                Class clazz = uriMap.getParams()[2];
                uriMap.getMethod().invoke(uriMap.getService(),request,response,dataToBean(poData,clazz));
            }
        } catch (Exception e2) {
            e = e2;
        }
        if(e != null){
            Logger.error(ToolsUtils.getExceptionMessage(e,true),e);
            throw e;
        }
    }

    /**
     * json接口
     * @param request request
     * @return 返回的数据
     */
    @RequestMapping(value = "/json/{1}/{2}", produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    public Object json(HttpServletRequest request){
        Object result = actionAjax(request,"json");
        return result;
    }

    /**
     * jsonp接口
     * @param request request
     * @return 返回的数据
     */
    @RequestMapping(value = "/jsonp/{1}/{2}", produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    public String jsonp(HttpServletRequest request){
        Object result = actionAjax(request,"jsonp");
        String callback = request.getParameter("callback");
        if(callback == null || "".equals(callback)){
            callback = "callback";
        }
        return callback+"("+ JSONUtil.toJsonStr(result) +")";
    }

    /**
     * 字段校验
     * @param uriMap 映射的实体
     * @param poData 入参
     */
    private void checkField(UriMap uriMap,PoData poData){
        if("0".equals(uriMap.getCheckType())){
            List<PoData> forceFields = uriMap.getForceFields();
            if(forceFields == null || forceFields.size() == 0){
                return;
            }
            //params校验
            String body = poData.getRequestBody();
            if(StrUtil.isNotBlank(body)){
                JSONObject json = JSONUtil.parseObj(body);
                for(PoData forceMap:forceFields){
                    String field = forceMap.getStr("field");
                    String name = forceMap.getStr("name");
                    Assert.notBlank(json.getStr(field),"{}不可为空",name);
                }
            }else{
                for(PoData forceMap:forceFields){
                    String field = forceMap.getStr("field");
                    String name = forceMap.getStr("name");
                    Assert.notBlank(poData.getStr(field),"{}不可为空",name);
                }
            }
        }else if("1".equals(uriMap.getCheckType())){
            //实体校验
            Class clazz = uriMap.getEntity();
            Object t = dataToBean(poData,clazz);
            if(t == null){
                List<PoData> forceFields = uriMap.getForceFields();
                if(forceFields == null || forceFields.size() == 0){
                    return;
                }
            }
            Assert.notNull(t,"校验实体不可为空");
            Validator validator = UriHandComponent.getValidator();
            Set<ConstraintViolation<Object>> set =  validator.validate(t,uriMap.getGroups());
            if(set.size() == 0){
                return;
            }
            Assert.isTrue(false,set.iterator().next().getMessage());
        }
    }

    /**
     * json,jsonp公用的处理机制
     * @param request request
     * @param type 方法类型
     * @return 返回数据
     */
    private Object actionAjax(HttpServletRequest request,String type){
        PoData poData = readRequestData(request);
        if(StrUtil.equals(type,"jsonp")){
            poData.remove("callback");
        }
        Object result = null;
        try {
            UriMap uriMap= UriHandComponent.handMap.get(request.getRequestURI());
            int length = uriMap.getParams().length;
            checkField(uriMap,poData);
            if(length == 1){
                result =uriMap.getMethod().invoke(uriMap.getService(),poData);
            }else if(length == 2){
                Class clazz = uriMap.getParams()[1];
                result =uriMap.getMethod().invoke(uriMap.getService(),poData,dataToBean(poData,clazz));
            }
        } catch (Throwable e) {
            while(true){
                if(e instanceof InvocationTargetException){
                    //反射异常处理
                    e = ((InvocationTargetException) e).getTargetException();
                }else{
                    break;
                }
            }
            Logger.error(ToolsUtils.getExceptionMessage(e,true),e);
            result = UriHandComponent.getNoControllerInterface().errorHandler(e);
            if(result == null){
                result =R.error(e);
            }
        }
        return result;
    }

    /**
     * 文档接口数据地址
     * @param request request
     * @return 文档数据
     */
    @RequestMapping(value = UriHandComponent.INTERFACE_URI, produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    public R doclist(HttpServletRequest request){
        PoData res = UriHandComponent.getDocData();
        if(StrUtil.isBlank(controllerFreeProperties.getPassword())){
            return R.okData(res);
        }
        String key = request.getParameter("key");
        if(StrUtil.isBlank(key)){
            return R.failed("请输入密码");
        }
        if(!controllerFreeProperties.getPassword().equals(key)){
            return R.failed("请输入密码");
        }
        return R.okData(res);
    }

    /**
     * 将request转成map
     * @param request request
     * @return map
     */
    private static PoData readRequestData(HttpServletRequest request){
        PoData poData = PoData.create();
        poData.putAll(ServletUtil.getParamMap(request));
        String requestBody = ServletUtil.getBody(request);
        if(StrUtil.isNotBlank(requestBody)){
            poData.setRequestBody(requestBody);
        }
        return poData;
    }

    /**
     * 将map转成实体
     * @param data map
     * @param clazz 实体类
     * @param <T> 实体类
     * @return 实体
     */
    private static <T> T dataToBean(PoData data,Class clazz){
        String requestBody = data.getRequestBody();
        if(StrUtil.isNotBlank(requestBody)){
            return (T)JSONUtil.toBean(requestBody,clazz);
        }
        return (T)data.toBean(clazz);
    }
}

