package cn.tenfell.plugins.controllerfree.component;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.tenfell.plugins.controllerfree.annotation.*;
import cn.tenfell.plugins.controllerfree.config.ControllerFreeProperties;
import cn.tenfell.plugins.controllerfree.entity.*;
import cn.tenfell.plugins.controllerfree.inface.NoControllerInterface;
import cn.tenfell.plugins.controllerfree.utils.AopTargetUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 文档生成组件
 * @author fs
 */
@Component
public class UriHandComponent implements ApplicationContextAware {
    /**
     * 未注解时候的默认方法注解
     */
    private static InterfaceDoc defInterfaceDoc;
    /**
     * 接口文档列表
     */
    private static List<InterfaceDocEntity> interfaceList;
    /**
     * Javax校验器
     */
    private static Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
    /**
     * 文档生成的时间
     */
    private static String interfaceCreateTime;
    /**
     * 接口地址map
     */
    public static final Map<String, UriMap> handMap = new HashMap<>();
    /**
     * 接口文档数据获取的地址
     */
    public static final String INTERFACE_URI = "/interface/doclist";
    /**
     * 实现了NoControllerInterface接口的组件
     */
    private static NoControllerInterface noControllerInterface;
    /**
     * 通用配置文件
     */
    private static ControllerFreeProperties controllerFreeProperties;
    /**
     * app上下文
     */
    private static ApplicationContext applicationContext;
    /**
     * 模块缓存数据
     */
    private static Map<String, ServiceCacheData> serviceCacheDataMap = new HashMap<>();

    /**
     * 获取NoControllerInterface实现类
     * @return 实现类
     */
    public static NoControllerInterface getNoControllerInterface(){
        return noControllerInterface;
    }

    /**
     * 获取校验器
     * @return 校验器
     */
    public static Validator getValidator(){
        return validator;
    }

    /**
     * 获取文档数据
     * @return 文档数据
     */
    public static PoData getDocData(){
        PoData data = PoData.create()
                .set("list",UriHandComponent.interfaceList)
                .set("time",UriHandComponent.interfaceCreateTime);
        return data;
    }
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        UriHandComponent.applicationContext = applicationContext;
        try{
            NoControllerInterface noControllerInterface = applicationContext.getBean(NoControllerInterface.class);
            UriHandComponent.noControllerInterface = noControllerInterface;
        }catch (NoSuchBeanDefinitionException e){
            throw new RuntimeException("请用Spring组件实现NoControllerInterface接口",e);
        }
        try{
            ControllerFreeProperties controllerFreeProperties = applicationContext.getBean(ControllerFreeProperties.class);
            UriHandComponent.controllerFreeProperties = controllerFreeProperties;
        }catch (NoSuchBeanDefinitionException e){
            throw new RuntimeException("配置项读取异常",e);
        }
        try{
            defInterfaceDoc = EmptyClass.class.getDeclaredMethod("emptyMethod").getAnnotation(InterfaceDoc.class);
        }catch (Exception e){

        }
        updateHandMap(null);
    }

    /**
     * 更新文档
     * @param service 模块
     * @param key 地址
     */
    private static void updateHandMapOneService(Object service,String key){
        String[] conMappings = {"json","jsonp"};
        //原对象,用于获取注解
        Object serviceTarget = AopTargetUtils.getTarget(service);
        ServiceCacheData serviceCacheData = new ServiceCacheData();
        serviceCacheData.setService(serviceTarget);
        serviceCacheData.setServiceName(key);
        List<Method> methodList = new ArrayList<Method>();
        Method[] methods = serviceTarget.getClass().getDeclaredMethods();
        for(Method method:methods){
            Class<?>[] types = method.getParameterTypes();
            int type = getType(types);
            if(type == 0){
                continue;
            }
            UriMap uriMap = new UriMap();
            uriMap.setService(service);
            uriMap.setMethod(method);
            uriMap.setParams(types);
            NeedLogin needLogin = method.getAnnotation(NeedLogin.class);
            NotNeedLogin notNeedLogin = method.getAnnotation(NotNeedLogin.class);
            uriMap.setNeedLogin(getNeedLogin(needLogin,notNeedLogin));
            if(type == 1){
                //表示要处理的json,jsonp
                for(String conMapping:conMappings){
                    String mapKey = "/"+conMapping+"/"+key+"/"+method.getName();
                    handMap.put(mapKey,uriMap);
                }
            }else if(type == 2){
                //表示要处理的selevt
                String mapKey = "/selevt/"+key+"/"+method.getName();
                handMap.put(mapKey,uriMap);
            }
            methodList.add(method);
        }
        serviceCacheData.setMethods(methodList);
        serviceCacheDataMap.put(key,serviceCacheData);
    }

    /**
     * 判断该方法是否需要登录
     * @param needLogin 登录注解
     * @param notNeedLogin 免登录注解
     * @return 是否需要登录
     */
    private static boolean getNeedLogin(NeedLogin needLogin,NotNeedLogin notNeedLogin){
        ControllerFreeProperties.NeedLogin need = controllerFreeProperties.getDefaultNeedLogin();
        boolean defaultLogin = need == ControllerFreeProperties.NeedLogin.OPEN;
        if(needLogin != null && notNeedLogin != null){
            return defaultLogin;
        }
        if(needLogin == null && notNeedLogin == null){
            return defaultLogin;
        }
        return needLogin != null;
    }

    /**
     * 更新文档数据
     * @param serviceName 模块名
     */
    public static void updateHandMap(String serviceName){
        Map<String, Object> serviceMap =  applicationContext.getBeansWithAnnotation(Service.class);
        if(StrUtil.isBlank(serviceName)){
            /*初始化*/
            Set<String> keys = serviceMap.keySet();
            for(String key:keys){
                Object service = serviceMap.get(key);
                updateHandMapOneService(service,key);
            }
        }else{
            /*更新*/
            Object service = serviceMap.get(serviceName);
            if(service == null){
                return;
            }
            updateHandMapOneService(service,serviceName);
        }
        ThreadUtil.execute(new Runnable() {
            @Override
            public void run() {
                updateInterfaceList();
            }
        });
    }

    /**
     * 更新全部文档数据
     */
    private static void updateInterfaceList(){
        interfaceList = new ArrayList<>();
        String[] conMappings = {"json","jsonp"};
        Set<String> keys = serviceCacheDataMap.keySet();
        for(String key:keys){
            ServiceCacheData serviceCacheData = serviceCacheDataMap.get(key);
            InterfaceDocEntity interfaceDocEntity = null;
            List<InterfaceDocChild> interfaceDocChildren = null;
            Object service = serviceCacheData.getService();
            List<Method> methodList = serviceCacheData.getMethods();
            for(Method method:methodList){
                Class<?>[] types = method.getParameterTypes();
                InterfaceDoc interfaceDoc = method.getAnnotation(InterfaceDoc.class);
                if(interfaceDoc == null){
                    interfaceDoc = defInterfaceDoc;
                }
                int type = getType(types);
                if(type==0){
                    continue;
                }
                if(interfaceDocEntity == null){
                    interfaceDocEntity = new InterfaceDocEntity();
                    interfaceDocChildren = new ArrayList<InterfaceDocChild>();
                    String moduleName = serviceCacheData.getServiceName();
                    InterfaceModule interfaceModule = service.getClass().getAnnotation(InterfaceModule.class);
                    if(interfaceModule != null && !"".equals(interfaceModule.value())){
                        moduleName = interfaceModule.value();
                    }
                    interfaceDocEntity.setName(moduleName);
                }
                InterfaceDocChild interfaceDocChild = new InterfaceDocChild();
                String interfaceName = method.getName();
                if(!"".equals(interfaceDoc.name())){
                    interfaceName = interfaceDoc.name();
                }
                interfaceDocChild.setName(interfaceName);
                List<InterfaceParams> interfaceParamsList = new ArrayList<InterfaceParams>();
                List<PoData> forceFields = new ArrayList<>();
                Class clazz = interfaceDoc.entity();
                String checkType;//0为params校验 1为实体校验
                Class entity = null;//实体校验类型
                Class[] checkGroups = null;//实体校验组
                if(clazz != EmptyClass.class){
                    /**
                     * 通过实体来校验字段
                     */
                    checkType = "1";
                    entity = clazz;
                    Field[] fields = clazz.getDeclaredFields();
                    PoData fieldMap = PoData.create();
                    for(Field field:fields){
                        InterfaceField ifi = field.getAnnotation(InterfaceField.class);
                        if(ifi != null){
                            PoData fieldDescr = PoData.create()
                                    .set("field",field.getName())
                                    .set("name",ifi.value())
                                    .set("descr",ifi.descr());
                            fieldMap.set(field.getName(),fieldDescr);
                        }
                    }
                    Class[] groups = interfaceDoc.groups();
                    checkGroups = groups;
                    BeanDescriptor beanDescriptor = validator.getConstraintsForClass(clazz);
                    if(beanDescriptor != null){
                        Set<PropertyDescriptor> sets = beanDescriptor.getConstrainedProperties();
                        for(PropertyDescriptor prop:sets){
                            String field = prop.getPropertyName();
                            PoData fieldParam = (PoData)fieldMap.get(field);
                            InterfaceParams ips = new InterfaceParams();
                            if (fieldParam != null){
                                ips.setField(fieldParam.getStr("field"));
                                ips.setName(fieldParam.getStr("name"));
                                ips.setDescr(fieldParam.getStr("descr"));
                                fieldMap.remove(field);
                            }else{
                                ips.setField(field);
                                ips.setName("");
                                ips.setDescr("");
                            }
                            boolean forceIs = false;
                            Set<ConstraintDescriptor<?>> cds = prop.getConstraintDescriptors();
                            for(ConstraintDescriptor cd:cds){
                                Class annClass =  cd.getAnnotation().annotationType();
                                if(annClass != NotBlank.class && annClass != NotEmpty.class){
                                    continue;
                                }
                                Set<Class<?>>  cgroups = cd.getGroups();
                                if(cgroups.size() == 0 && groups.length == 0){
                                    forceIs = true;
                                    break;
                                }
                                if(cgroups.contains(Default.class)){
                                    forceIs = true;
                                    break;
                                }
                                for(Class group:groups){
                                    if(cgroups.contains(group)){
                                        forceIs = true;
                                        break;
                                    }
                                }
                                if(forceIs){
                                    break;
                                }
                            }
                            ips.setForceIs(forceIs);
                            interfaceParamsList.add(ips);
                            if(forceIs){
                                PoData forceMap = PoData.create()
                                        .set("field",ips.getField())
                                        .set("name",ips.getName())
                                        .set("descr",ips.getDescr());
                                forceFields.add(forceMap);
                            }
                        }
                    }
                    Set<String> sets = fieldMap.keySet();
                    for(String set:sets){
                        PoData fieldParam = (PoData)fieldMap.get(set);
                        InterfaceParams ips = new InterfaceParams();
                        ips.setForceIs(false);
                        ips.setField(fieldParam.getStr("field"));
                        ips.setName(fieldParam.getStr("name"));
                        ips.setDescr(fieldParam.getStr("descr"));
                        interfaceParamsList.add(ips);
                    }
                }else{
                    /**
                     * 通过params来校验字段
                     */
                    checkType = "0";
                    InterfaceForm[] params = interfaceDoc.params();
                    for(InterfaceForm param:params){
                        InterfaceParams ips = new InterfaceParams();
                        ips.setField(param.field());
                        ips.setName(param.name());
                        ips.setForceIs(param.force());
                        ips.setDescr(param.descr());
                        if(param.force()){
                            PoData forceMap = PoData.create()
                                    .set("field",ips.getField())
                                    .set("name",ips.getName())
                                    .set("descr",ips.getDescr());
                            forceFields.add(forceMap);
                        }
                        interfaceParamsList.add(ips);
                    }
                }
                interfaceDocChild.setParams(interfaceParamsList);
                List<String> urlList = new ArrayList<String>();
                if(type == 1){
                    //表示要处理的json,jsonp
                    for(String conMapping:conMappings){
                        String mapKey = "/"+conMapping+"/"+serviceCacheData.getServiceName()+"/"+method.getName();
                        urlList.add(mapKey);
                        UriMap uriMap = handMap.get(mapKey);
                        if(uriMap != null){
                            uriMap.setForceFields(forceFields);
                            uriMap.setCheckType(checkType);
                            uriMap.setEntity(entity);
                            uriMap.setGroups(checkGroups);
                        }
                    }
                }else if(type == 2){
                    //表示要处理的selevt
                    String mapKey = "/selevt/"+serviceCacheData.getServiceName()+"/"+method.getName();
                    urlList.add(mapKey);
                    UriMap uriMap = handMap.get(mapKey);
                    if(uriMap != null){
                        uriMap.setForceFields(forceFields);
                        uriMap.setCheckType(checkType);
                        uriMap.setEntity(entity);
                        uriMap.setGroups(checkGroups);
                    }
                }
                interfaceDocChild.setUrlList(urlList);
                interfaceDocChildren.add(interfaceDocChild);
            }
            if(interfaceDocEntity != null){
                interfaceDocEntity.setList(interfaceDocChildren);
                interfaceList.add(interfaceDocEntity);
            }
        }
        interfaceCreateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }

    /**
     * 获取文档接口类型0不生成文档 1生成json,jsonp 2生成selevt
     * @param types 方法的入参类型
     * @return 文档接口类型
     */
    private static int getType(Class<?>[] types){
        if(types == null || types.length == 0){
            return 0;
        }
        if(types.length == 1 || types.length == 2){
            if(types[0] == PoData.class){
                return 1;
            }
        }
        if(types.length == 2 || types.length == 3){
            if(types[0] == HttpServletRequest.class && types[1] == HttpServletResponse.class){
                return 2;
            }

        }
        return 0;
    }

}

