/*
 * Decompiled with CFR 0.152.
 */
package cn.tenfell.plugins.controllerfree.filter;

import cn.tenfell.plugins.controllerfree.component.UriHandComponent;
import cn.tenfell.plugins.controllerfree.entity.R;
import cn.tenfell.plugins.controllerfree.utils.ToolsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class BaseWebExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(BaseWebExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    Object exception(Exception e) {
        Object result = UriHandComponent.getNoControllerInterface().errorHandler(e);
        if (result == null) {
            result = R.error(e);
        }
        log.debug(ToolsUtils.getExceptionMessage(e, true), (Throwable)e);
        return result;
    }
}

