package cn.tenfell.plugins.controllerfree.annotation;

import cn.tenfell.plugins.controllerfree.component.CtrlfreeRegistrar;
import cn.tenfell.plugins.controllerfree.config.ControllerFreeProperties;
import cn.tenfell.plugins.controllerfree.config.NoControllerConfiguration;
import org.springframework.context.annotation.Import;

import java.lang.annotation.*;
/**
 * 启动注解
 * @author fs
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
@Documented
@Import({NoControllerConfiguration.class, CtrlfreeRegistrar.class})
public @interface EnableControllerFree {
    /**
     * 文档访问密码
     */
    String password() default "";
    /**
     * 接口限制登录,默认为CLOSE
     */
    ControllerFreeProperties.NeedLogin defaultNeedLogin() default ControllerFreeProperties.NeedLogin.CLOSE;
}
