package cn.tenfell.plugins.controllerfree.component;

import cn.hutool.core.lang.Assert;
import cn.tenfell.plugins.controllerfree.entity.R;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
/**
 * 公共抽象Service
 * @author fs
 */
public abstract class BaseService {
    /**
     * 分页返回
     * @param data 数据
     * @param total 长度
     * @param <T> 类型
     * @return 分页数据
     */
    public <T> R page(T data, Long total) {
        return R.page(data,total);
    }

    /**
     * 成功返回
     * @return 成功数据
     */
    public R ok() {
        return R.ok();
    }

    /**
     * 携数据成功返回
     * @param data 数据
     * @param <T> 数据类型
     * @return 成功数据
     */
    public <T> R okData(T data) {
        return R.okData(data);
    }

    /**
     * 携消息成功返回
     * @param msg 消息
     * @return 成功数据
     */
    public R ok(String msg) {
        return R.ok(msg);
    }

    /**
     * 携数据和消息成功返回
     * @param data 数据
     * @param msg 消息
     * @param <T> 类型
     * @return 成功数据
     */
    public <T> R ok(T data,String msg) {
        return R.ok(data,msg);
    }

    /**
     * 失败返回
     * @return 失败数据
     */
    public R failed() {
        return R.failed();
    }

    /**
     * 携消息失败返回
     * @param msg 消息
     * @return 失败数据
     */
    public R failed(String msg) {
        return R.failed(msg);
    }

    /**
     * 携异常信息返回
     * @param error 异常信息
     * @param msg 消息
     * @return 错误数据
     */
    public R error(String error,String msg) {
        return R.error(error,msg);
    }

    /**
     * 携异常返回
     * @param e 异常
     * @return 错误数据
     */
    public R error(Exception e) {
        return R.error(e);
    }

    /**
     * 获取登录用户
     * @param <T> 类型
     * @return 登录用户
     */
    public <T> T getUser(){
        Assert.notNull(UriHandComponent.getNoControllerInterface());
        return (T)UriHandComponent.getNoControllerInterface().getLoginUser(getRequest());
    }

    /**
     * 获取request
     * @return Request
     */
    public HttpServletRequest getRequest(){
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        Assert.notNull(ra);
        HttpServletRequest request = ((ServletRequestAttributes) ra).getRequest();
        return request;
    }

    /**
     * 获取session
     * @return session
     */
    public HttpSession getSession() {
        HttpServletRequest request = getRequest();
        Assert.notNull(request);
        HttpSession session = request.getSession();
        return session;
    }
}
