package cn.tenfell.plugins.controllerfree.entity;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.StrUtil;
import java.util.Date;

/**
 * 通用MAP
 * @author fs
 */
public class PoData extends Dict{
    /**
     * json传输存body
     */
    private String requestBody;
    public String getRequestBody() {
        return requestBody;
    }
    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }
    private static final long serialVersionUID = 1L;

    /**
     * 覆盖父类方法,参见父类
     * @return 当前实体
     */
    public static PoData create() {
        return new PoData();
    }

    /**
     * 覆盖父类方法,参见父类
     * @param bean 需要转化的实体
     * @param <T> 类型
     * @return PoData
     */
    public static <T> PoData parse(T bean) {
        return create().parseBean(bean);
    }

    /**
     * 覆盖父类方法,参见父类
     * @param attr key
     * @param value val
     * @return 当前实体
     */
    @Override
    public PoData set(String attr, Object value) {
        super.set(attr,value);
        return this;
    }

    /**
     * 覆盖父类方法,参见父类
     * @param flag 是否set
     * @param attr key
     * @param value val
     * @return 当前实体
     */
    public PoData set(boolean flag,String attr, Object value) {
        if(!flag){
            return this;
        }
        return this.set(attr,value);
    }

    /**
     * 覆盖父类方法,参见父类
     * @param bean 实体
     * @param <T> 类型
     * @return 当前实体
     */
    @Override
    public <T> PoData parseBean(T bean) {
        super.parseBean(bean);
        return this;
    }

    /**
     * 覆盖父类方法,参见父类
     * @return 当前实体
     */
    @Override
    public PoData clone() {
        return (PoData)super.clone();
    }

    /**
     * 覆盖父类方法,参见父类
     * @param keys 过滤keys
     * @return 当前实体
     */
    @Override
    public PoData filter(String... keys) {
        final PoData result = PoData.create();
        for (String key : keys) {
            if (this.containsKey(key)) {
                result.put(key, this.get(key));
            }
        }
        return result;
    }

    /**
     * 覆盖父类方法,参见父类
     * @param bean 实体
     * @param isToUnderlineCase 是否下划线
     * @param ignoreNullValue 是否跳过空值
     * @param <T> 类型
     * @return 当前实体
     */
    @Override
    public <T> PoData parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        super.parseBean(bean,isToUnderlineCase,ignoreNullValue);
        return this;
    }

    /**
     * 覆盖父类方法,参见父类
     * @param attr key
     * @param value val
     * @return 当前实体
     */
    @Override
    public PoData setIgnoreNull(String attr, Object value) {
        super.setIgnoreNull(attr,value);
        return this;
    }

    /**
     * val转jdk时间
     * @param attr 当前key值
     * @return jdk时间
     */
    @Override
    public Date getDate(String attr){
        DateTime dt=getDateTime(attr);
        if(dt == null){
            return null;
        }else{
            return dt.toJdkDate();
        }
    }

    /**
     * val转时间
     * @param attr 当前key值
     * @return 时间
     */
    public DateTime getDateTime(String attr){
        Object obj = this.getObj(attr);
        if(obj == null){
            return null;
        }else if(obj instanceof DateTime){
            return (DateTime)obj;
        }else if(obj instanceof Date){
            return DateUtil.date((Date)obj);
        }else if(obj instanceof String){
            String str = (String)obj;
            if(StrUtil.isBlank(str)){
                return null;
            }
            Date date = Convert.toDate(str);
            Assert.notNull(date,"当前数据不能转化成时间:{}",str);
            return DateUtil.date(date);
        }else if(obj instanceof Long){
            Long lg = (Long)obj;
            if(lg == null){
                return null;
            }
            return DateUtil.date(lg);
        }else{
            Assert.isTrue(false,"当前数据不能转化成时间:{}",obj);
        }
        return null;
    }
}
