package cn.tenfell.plugins.controllerfree.entity;

import cn.hutool.core.util.StrUtil;
import cn.tenfell.plugins.controllerfree.utils.ToolsUtils;
import java.util.HashMap;
/**
 * 通用前台返回值
 */
public class R extends HashMap<String,Object> {
    private static final long serialVersionUID = 1L;
    public static <T> R page(T data,Long total) {
        return restResult(data,total, ResponseStatus.SUCCESS, "操作成功",null);
    }
    public static R ok() {
        return restResult(null, null,ResponseStatus.SUCCESS, "操作成功",null);
    }
    public static <T> R okData(T data) {
        return restResult(data,null, ResponseStatus.SUCCESS, "操作成功",null);
    }
    public static <T> R ok(T data,String msg) {
        if(StrUtil.isBlank(msg)){
            return okData(data);
        }
        return restResult(data,null, ResponseStatus.SUCCESS, msg,null);
    }
    public static R ok(String msg) {
        if(StrUtil.isBlank(msg)){
            return ok();
        }
        return restResult(null,null, ResponseStatus.SUCCESS, msg,null);
    }
    public static R error(String error,String msg) {
        return restResult(null,null, ResponseStatus.FAILED, msg,error);
    }
    public static R error(Throwable e) {
        String error = ToolsUtils.getExceptionMessage(e,true);
        String msg = ToolsUtils.getExceptionMessage(e,false);
        return error(error,msg);
    }
    public static R failed() {
        return restResult(null,null, ResponseStatus.FAILED, "操作失败",null);
    }
    public static <T> R failedData(T data) {
        return restResult(data,null, ResponseStatus.FAILED, "操作失败",null);
    }
    public static <T> R failed(T data,String msg) {
        if(StrUtil.isBlank(msg)){
            return failedData(data);
        }
        return restResult(data,null, ResponseStatus.FAILED, msg,null);
    }
    public static R failed(String msg) {
        if(StrUtil.isBlank(msg)){
            return failed();
        }
        return restResult(null,null, ResponseStatus.FAILED,msg,null);
    }
    private static <T> R restResult(T data, Long total, ResponseStatus status, String msg,String error) {
        R r = new R();
        r.set("status", status)
        .set(total!=null,"total", total)
        .set(data!=null,"data", data)
        .set(error!=null,"error", error)
        .set("msg", msg);
        return r;
    }
    public R set(String attr,Object object){
        return set(true,attr,object);
    }
    public R set(boolean flag,String attr,Object object){
        if(flag){
            this.put(attr,object);
        }
        return this;
    }
}
