package cn.tenfell.plugins.controllerfree.filter;

import cn.tenfell.plugins.controllerfree.component.UriHandComponent;
import cn.tenfell.plugins.controllerfree.entity.R;
import cn.tenfell.plugins.controllerfree.utils.ToolsUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * 全局异常拦截
 */
@RestControllerAdvice
@Slf4j
public class BaseWebExceptionHandler {
    /**
     * 所有异常拦截
     * @param e 异常
     * @return 返回数据
     */
    @ExceptionHandler(Exception.class)
    Object exception(Exception e){
        Object result = UriHandComponent.getNoControllerInterface().errorHandler(e);
        if(result == null){
            result = R.error(e);
        }
        log.debug(ToolsUtils.getExceptionMessage(e,true),e);
        return result;
    }
}
